/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.framework.shiro.service;

import com.bcxin.platform.common.core.domain.entity.SysUser;
import com.bcxin.platform.common.enums.UserStatus;
import com.bcxin.platform.common.exception.user.CaptchaException;
import com.bcxin.platform.common.exception.user.UserBlockedException;
import com.bcxin.platform.common.exception.user.UserDeleteException;
import com.bcxin.platform.common.exception.user.UserNotExistsException;
import com.bcxin.platform.common.exception.user.UserPasswordNotMatchException;
import com.bcxin.platform.common.utils.DateUtils;
import com.bcxin.platform.common.utils.MessageUtils;
import com.bcxin.platform.common.utils.ServletUtils;
import com.bcxin.platform.common.utils.ShiroUtils;
import com.bcxin.platform.framework.manager.AsyncManager;
import com.bcxin.platform.framework.manager.factory.AsyncFactory;
import com.bcxin.platform.framework.shiro.service.SysPasswordService;
import com.bcxin.platform.service.system.ISysUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class SysLoginService {
    @Autowired
    private SysPasswordService passwordService;
    @Autowired
    private ISysUserService userService;

    public SysUser login(String username, String password) {
        if ("captchaError".equals(ServletUtils.getRequest().getAttribute("captcha"))) {
            AsyncManager.me().execute(AsyncFactory.recordLogininfor(username, "Error", MessageUtils.message((String)"user.jcaptcha.error", (Object[])new Object[0]), new Object[0]));
            throw new CaptchaException();
        }
        if (StringUtils.isEmpty((Object)username) || StringUtils.isEmpty((Object)password)) {
            AsyncManager.me().execute(AsyncFactory.recordLogininfor(username, "Error", MessageUtils.message((String)"not.null", (Object[])new Object[0]), new Object[0]));
            throw new UserNotExistsException();
        }
        if (password.length() < 5 || password.length() > 20) {
            AsyncManager.me().execute(AsyncFactory.recordLogininfor(username, "Error", MessageUtils.message((String)"user.password.not.match", (Object[])new Object[0]), new Object[0]));
            throw new UserPasswordNotMatchException();
        }
        if (username.length() < 2 || username.length() > 20) {
            AsyncManager.me().execute(AsyncFactory.recordLogininfor(username, "Error", MessageUtils.message((String)"user.password.not.match", (Object[])new Object[0]), new Object[0]));
            throw new UserPasswordNotMatchException();
        }
        return this.login(username, password, true);
    }

    public SysUser login(String username, String password, boolean validatePassword) {
        SysUser user = this.userService.selectUserByLoginName(username);
        if (user == null) {
            AsyncManager.me().execute(AsyncFactory.recordLogininfor(username, "Error", MessageUtils.message((String)"user.not.exists", (Object[])new Object[0]), new Object[0]));
            throw new UserNotExistsException();
        }
        if (UserStatus.DELETED.getCode().equals(user.getDelFlag())) {
            AsyncManager.me().execute(AsyncFactory.recordLogininfor(username, "Error", MessageUtils.message((String)"user.password.delete", (Object[])new Object[0]), new Object[0]));
            throw new UserDeleteException();
        }
        if (UserStatus.DISABLE.getCode().equals(user.getStatus())) {
            AsyncManager.me().execute(AsyncFactory.recordLogininfor(username, "Error", MessageUtils.message((String)"user.blocked", (Object[])new Object[]{user.getRemark()}), new Object[0]));
            throw new UserBlockedException();
        }
        if (validatePassword) {
            this.passwordService.validate(user, password);
        }
        AsyncManager.me().execute(AsyncFactory.recordLogininfor(username, "Success", MessageUtils.message((String)"user.login.success", (Object[])new Object[0]), new Object[0]));
        this.recordLoginInfo(user);
        return user;
    }

    public void recordLoginInfo(SysUser user) {
        user.setLoginIp(ShiroUtils.getIp());
        user.setLoginDate(DateUtils.getNowDate());
        this.userService.updateUserInfo(user);
    }
}

