/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.framework.config.datasource;

import com.alibaba.druid.pool.DruidDataSource;
import javax.sql.DataSource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

@Configuration
@MapperScan(basePackages={"com.bcxin.obpm.mapper"}, sqlSessionFactoryRef="obpmSqlSessionFactory")
public class ObpmDSConfig {
    private final String mapperLocation = "classpath:mapper/obpm/*.xml";

    @Bean(name={"obpmDataSource"})
    @ConfigurationProperties(prefix="obpm.datasource")
    public DataSource obpmDataSource() {
        return new DruidDataSource();
    }

    @Bean(name={"obpmSqlSessionFactory"})
    @ConditionalOnBean(name={"obpmDataSource"})
    public SqlSessionFactory obpmSqlSessionFactory(@Qualifier(value="obpmDataSource") DataSource obpmDataSource) throws Exception {
        SqlSessionFactoryBean sessionFactory = new SqlSessionFactoryBean();
        sessionFactory.setDataSource(obpmDataSource);
        sessionFactory.setMapperLocations(new PathMatchingResourcePatternResolver().getResources("classpath:mapper/obpm/*.xml"));
        return sessionFactory.getObject();
    }
}

