<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('approve_role', function (Blueprint $table) {
            $table->id();
            $table->unsignedInteger('entid')->default(0)->comment('企业ID');
            $table->string('name',64)->default('')->comment('角色名称');
            $table->text('uids')->default('')->comment('角色人员ID');
            $table->unsignedInteger('user_count')->default(0)->comment('人员数量');
            $table->unsignedInteger('status')->default(1)->comment('状态：开启1，关闭0');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('approve_role');
    }
};
