import { download, requestAccess, serviceAccess } from "./request";
/**
 * @typedef projectData
 * 赛演统计-项目列表
 * @type {object}
 * @property {string} id 项目id
 * @property {string | undefined} itemDomainId 组织id
 * @property {string | undefined} itemDomainName 组织名称
 * @property {string | undefined} itemProjectEndTime 项目结束时间
 * @property {string | undefined} itemProjectName 项目名称
 *
 */

/**
 * 赛演统计-项目列表
 * 这个接口返回值不符合code,data规范，所以不用requestAccess
 * @returns {projectData}
 */
export const getProject = () => {
  return serviceAccess({
    url: "/sy/statistics/project",
    method: "post",
    data: {},
  });
};
/**
 * @typedef siteData
 * 赛演统计-考勤组（岗点）列表
 * @type {object}
 * @property {string | undefined} domainid 组织id
 * @property {string} id 考勤组（岗点）id
 * @property {string | undefined} itemAttType 考勤类型
 * @property {string | undefined} itemAttendanceEndDate 考勤结束时间
 * @property {string | undefined} itemAttendanceSiteFullAddress 考勤地点全称
 * @property {number | undefined} itemAttendanceSiteLatitude 考勤地点纬度
 * @property {number | undefined} itemAttendanceSiteLongitude 考勤地点经度
 * @property {string | undefined} itemAttendanceSiteName 考勤地点名称
 * @property {string | undefined} itemAttendanceSiteState 考勤地点状态
 * @property {string | undefined} itemAttendanceStartDate 考勤开始时间
 * @property {string | undefined} itemIsdeleted 是否删除
 * @property {number | undefined} itemPerformRange 考勤范围
 * @property {string | undefined} itemPrincipal 负责人
 * @property {string | undefined} itemProjectId 项目id
 *
 * */

/**
 * @typedef siteParams
 * 赛演统计-考勤组（岗点）列表 接口参数
 * @type {object}
 * @property {string} projectId 项目id
 * @property {string[]} teamIdList 团队组织id列表，数组（是用获取团队列表接口的itemTeamId字段，不要用id）
 *
 * */

/**
 * 赛演统计-考勤组（岗点）列表
 * @param {siteParams} data
 * @returns {siteData}
 */
export const getSite = (data) => {
  return requestAccess({
    url: "/sy/statistics/site",
    method: "post",
    data,
  });
};
/**
 * @typedef teamDataParams
 * 赛演统计-团队列表 接口参数
 * @type {object}
 * @property {string} projectId 项目id
 */

/**
 * @typedef teamData
 * 赛演统计-团队列表
 * @type {object}
 * @property {string} id 团队id
 * @property {string | undefined} itemProjectId 项目id
 * @property {string} itemTeamId 团队组织id
 * @property {string | undefined} itemTeamName 团队组织名称
 */

/**
 * 赛演统计-团队列表
 * @param {teamDataParams} data
 * @returns {teamData}
 */
export const getTeam = (data) => {
  return requestAccess({
    url: "/sy/statistics/team",
    method: "post",
    data,
  });
};

/**
 * @typedef attendanceParams
 * 赛演考勤统计 接口参数
 * @type {object}
 * @property {string} projectId 项目id
 * @property {string[]} siteIdList 考勤组（岗点）id列表，数组
 * @property {string[]} teamIdList 团队组织id列表，数组
 * @property {string} statisticsStartTime 统计开始时间，yyyy-MM-dd
 * @property {string} statisticsEndTime 统计结束时间，yyyy-MM-dd
 * @property {string} userName 姓名
 * @property {number} pageNum 页码
 * @property {number} pageSize 每页数量
 * @property {string} orderByColumn 排序字段
 * @property {string} isAsc 排序方式，asc升序，desc降序
 * @property {boolean} reasonable 是否合理，true是，false否
 * @property {number} operateType 操作类型(签到统计)，0：签到，1：签退
 *
 */

/**
 * @typedef attendanceData
 * 赛演考勤统计
 * @type {object}
 * @property {number} abnormalPeopleNumber 异常人数
 * @property {number} actualAttendanceTime 实际出勤时间
 * @property {number} actualClockInCount 实际签到次数
 * @property {number} entid
 * @property {string} groupName 考勤组名称
 * @property {number} lateCount 迟到次数
 * @property {number} latePeopleNumber 迟到人数
 * @property {number} leaveEarlyCount 早退次数
 * @property {number} leaveEarlyPeopleNumber 早退人数
 * @property {number} leaveTime 请假时间
 * @property {number} missingCount 缺勤次数
 * @property {number} normalPeopleNumber 正常人数
 * @property {string} projectName 项目名称
 * @property {string} shiftName 班次名称
 * @property {number} shouldAttendanceTime 应出勤时间
 * @property {number} shouldClockInCount 应签到次数
 * @property {string} statisticsDate 统计日期
 * @property {string} teamName 团队组织名称
 * @property {string} userName 姓名
 * @property {number} workOvertime 加班时间
 *
 */

/**
 * 赛演考勤统计
 * @param {attendanceParams} data
 * @returns {attendanceData}
 */
export const attendanceList = (data) => {
  return requestAccess({
    url: "/sy/statistics/attendance",
    method: "post",
    data,
  });
};

/**
 * 导出考勤统计
 * @param {attendanceParams} data
 * @returns
 */
export const attendanceExport = (data) => {
  return download("/sy/statistics/attendance/excel", data, "考勤统计.xlsx");
};

/**
 * @typedef singInData
 * 赛演签到统计
 * @type {object}
 * @property {string} employeeId 职员id
 * @property {string} operateAddress 操作地址
 * @property {number} operateCount 操作次数
 * @property {string} operateName 操作类型-中文
 * @property {string} operateTime 操作时间
 * @property {string} operateType 操作类型，0：签到，1：签退
 * @property {string} projectName 项目名称
 * @property {string} siteName 岗点名称
 * @property {string} statisticsDate 统计日期
 * @property {string} teamName 团队组织名称
 * @property {string} userName
 *
 */

/**
 * 赛演签到统计
 * @param {attendanceParams} data
 * @returns {singInData}
 */
export const signInList = (data) => {
  return requestAccess({
    url: "/sy/statistics/sign/in",
    method: "post",
    data,
  });
};

/**
 * 签到统计导出
 * @param {attendanceParams} data
 * @returns
 */
export const signInExport = (data) => {
  return download("/sy/statistics/sign/in/excel", data, "签到统计.xlsx");
};
