package com.bcxin.runtime.domain.snapshoots;

import com.bcxin.runtime.domain.syncs.commands.CreateDataSyncCommand;
import com.bcxin.runtime.domain.syncs.dtos.DataSetDto;
import lombok.Data;

import java.util.Collection;
import java.util.stream.Collectors;

@Data
public class SyncDataFileSnapshot {
    private Collection<SyncDataFileSnapshot.DataSet> dataSets;
    private String filePaths;

    public SyncDataFileSnapshot(){}

    public SyncDataFileSnapshot(Collection<SyncDataFileSnapshot.DataSet> dataSets, String filePaths) {
        this.setDataSets(dataSets);
        this.setFilePaths(filePaths);
    }

    public static SyncDataFileSnapshot create(Collection<SyncDataFileSnapshot.DataSet> dataSets, String filePaths) {
        return new SyncDataFileSnapshot(dataSets, filePaths);
    }

    public static SyncDataFileSnapshot create(CreateDataSyncCommand command) {
        Collection<SyncDataFileSnapshot.DataSet> dataSets = command.getDataSets().stream().map(ii -> {
            return DataSet.create(ii.getId(), ii.getMapKey(), ii.getRows(), ii.getDeletedIds());
        }).collect(Collectors.toList());

        return create(dataSets, command.getFilePaths());
    }

    @Data
    public static class DataSet {
        private String id;
        private String mapKey;
        private Collection<DataSetDto.Row> rows;
        private Collection<String> deletedIds;

        public DataSet() {
        }

        public DataSet(String id, String mapKey, Collection<DataSetDto.Row> rows,
                       Collection<String> deletedIds) {
            this.id = id;
            this.mapKey = mapKey;
            this.rows = rows;
            this.deletedIds = deletedIds;
        }

        public static DataSet create(String id, String mapKey,
                                     Collection<DataSetDto.Row> rows,
                                     Collection<String> deletedIds) {
            return new DataSet(id, mapKey, rows, deletedIds);
        }
    }
}
