package com.bcxin.runtime.domain.permissions.entities;

import com.bcxin.saas.core.IAggregate;
import com.bcxin.saas.core.models.EntityBase;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;
import java.sql.Timestamp;

/**
 * 目前是指企业的数据权限
 */
@Getter
@Entity
@Setter
@Table(name = "tenant_data_permissions")
public class DataPermissionScopeEntity  extends EntityBase<String> implements IAggregate {
    /**
     * 组织的Id
     */
    @Id
    @Column(length = 50)
    private String id;

    @Column(name = "content", nullable = false)
    private String content;

    @Column(name = "search_index_code", nullable = false)
    private String searchIndexCode;

    @Column(name = "created_time", nullable = false)
    private Timestamp createdTime;

    @Column(name = "last_updated_time", nullable = true)
    private Timestamp lastUpdatedTime;

    protected DataPermissionScopeEntity() {

    }
}
