package com.bcxin.runtime.domain.metas.entities;

import com.bcxin.runtime.domain.metas.entities.enums.StartupType;
import com.bcxin.saas.core.IAggregate;
import com.bcxin.saas.core.models.EntityBase;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;
import javax.persistence.*;
import java.util.Date;
import java.util.UUID;

@Getter
@Setter(AccessLevel.PROTECTED)
@Entity
@Table(name = "meta_tasks")
public class TaskMetaEntity extends EntityBase<String> implements IAggregate {
    @Id
    @Column(length = 50)
    private String id;
    @Column(length = 250)
    private String name;

    @Column(name = "task_id", length = 50, nullable = false)
    private String taskId;
    @Column(length = 500)
    private String note;
    @Column(length = 500, nullable = false)
    private String path;
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "last_updated_time", nullable = false)
    private Date lastUpdatedTime;

    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "last_executed_time", nullable = true)
    private Date lastExecutedTime;

    @Column(name = "executed_count", nullable = false)
    private int executedCount;

    @Enumerated(EnumType.ORDINAL)
    @Column(name = "startup_type", nullable = false)
    private StartupType startupType;

    @Column(columnDefinition = "text")
    private String config;
    @ManyToOne
    @JoinColumn(name = "application_meta_id")
    private ApplicationMetaEntity applicationMeta;

    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "created_time", nullable = false, columnDefinition = "DATETIME default current_timestamp()")
    private Date createdTime;

    public void change(String name, StartupType startupType, String note, String config) {
        this.setName(name);
        this.setStartupType(startupType);
        this.setNote(note);
        this.setConfig(config);
        this.setLastExecutedTime(new Date());
    }

    protected TaskMetaEntity() {
        this.createdTime = new Date();
        this.lastUpdatedTime = this.createdTime;
    }

    private TaskMetaEntity(ApplicationMetaEntity applicationMetaEntity,
                           String taskId,String name, String path,
                           String note, String config) {
        this();
        this.setId(UUID.randomUUID().toString());
        this.setTaskId(taskId);
        this.setName(name);
        this.setPath(path);
        this.setNote(note);
        this.setConfig(config);
        this.setApplicationMeta(applicationMetaEntity);
    }

    public static TaskMetaEntity create(ApplicationMetaEntity applicationMetaEntity, String taskId,String name,String path, String note, String config) {
        return new TaskMetaEntity(applicationMetaEntity, taskId, name, path, note, config);
    }
}
