package com.bcxin.runtime.domain.metas.entities;
import com.bcxin.runtime.domain.metas.entities.enums.*;
import com.bcxin.saas.core.IAggregate;
import com.bcxin.saas.core.models.EntityBase;
import lombok.*;
import javax.persistence.*;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Optional;
import com.bcxin.runtime.domain.enums.BooleanStatus;

@Getter
@Setter(AccessLevel.PROTECTED)
@Entity
@Table(name = "meta_apps")
public class ApplicationMetaEntity extends EntityBase<String> implements IAggregate {
    @Id
    @Column(length = 50)
    private String id;
    @Column(length = 100, nullable = false,name = "app_id")
    private String appId;
    @Column(nullable = false)
    private String name;

    @Column(nullable = false,name = "is_online")
    private BooleanStatus isOnline;
    private String note;

    @OneToMany(mappedBy = "applicationMeta", fetch = FetchType.LAZY, cascade = CascadeType.ALL)
    private Collection<DataSourceMetaEntity> dataSourceMetas;
    @OneToMany(mappedBy = "applicationMeta", fetch = FetchType.LAZY, cascade = CascadeType.ALL)
    private Collection<FormMetaEntity> formMetas;

    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "last_updated_time", nullable = false)
    private Date lastUpdatedTime;

    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "created_time", nullable = false, columnDefinition = "DATETIME default current_timestamp()")
    private Date createdTime;

    protected ApplicationMetaEntity() {
        this.createdTime = new Date();
        this.lastUpdatedTime = this.createdTime;
        this.setIsOnline(BooleanStatus.FALSE);
    }

    public void change(String name, String note) {
        this.setName(name);
        this.setNote(note);
        this.setLastUpdatedTime(new Date());
    }

    public void addDataSourceMeta(String dataSourceId, String dsName, UseType dsDriveType,
                                  DbType dsDbType, String dsConfig, String dsNote, boolean isSelected) {
        if (this.getDataSourceMetas() != null) {
            Optional<DataSourceMetaEntity> metaEntityOptional =
                    this.getDataSourceMetas().stream()
                            .filter(ii -> dataSourceId.equals(ii.getDataSourceId()))
                            .findFirst();
            if (metaEntityOptional.isPresent()) {
                metaEntityOptional.get().change(dsName, dsDriveType, dsDbType, dsConfig, dsNote);
                metaEntityOptional.get().setIsSelected(isSelected?BooleanStatus.TRUE:BooleanStatus.FALSE);
                this.setLastUpdatedTime(new Date());

                return;
            }
        } else {
            this.dataSourceMetas = new ArrayList<>();
        }
        DataSourceMetaEntity dataSourceMetaEntity = DataSourceMetaEntity
                .create(dataSourceId, dsName, dsDriveType, dsDbType, dsConfig, dsNote);

        dataSourceMetaEntity.setApplicationMeta(this);
        dataSourceMetaEntity.setIsSelected(isSelected?BooleanStatus.TRUE:BooleanStatus.FALSE);
        this.getDataSourceMetas().add(dataSourceMetaEntity);
    }

    public void addFormMeta(String formId, String formName,String formTableName,FormType formType) {
        if (this.getFormMetas() != null) {
            Optional<FormMetaEntity> formMetaEntityOptional =
                    this.getFormMetas().stream().filter(ii ->
                            ii.getFormId().equals(formId)).findFirst();
            if (formMetaEntityOptional.isPresent()) {
                formMetaEntityOptional.get().change(formName, formTableName,formType);
                this.setLastUpdatedTime(new Date());
                return;
            }
        } else {
            this.formMetas = new ArrayList<>();
        }

        FormMetaEntity formMetaEntity = FormMetaEntity.create(formId, formName,
                formTableName,formType);
        formMetaEntity.setApplicationMeta(this);
        this.getFormMetas().add(formMetaEntity);
    }

    public static ApplicationMetaEntity create(String id, String appId, String name,
                                               boolean isOnline, String note) {
        ApplicationMetaEntity applicationMetaEntity = new ApplicationMetaEntity();
        applicationMetaEntity.setId(id);
        applicationMetaEntity.setName(name);
        applicationMetaEntity.setIsOnline(isOnline?BooleanStatus.TRUE:BooleanStatus.FALSE);
        applicationMetaEntity.setNote(note);
        applicationMetaEntity.setAppId(appId);

        applicationMetaEntity.setFormMetas(new ArrayList<>());
        applicationMetaEntity.setDataSourceMetas(new ArrayList<>());

        return applicationMetaEntity;
    }
}
