package com.bcxin.runtime.domain.imports.entities;

import com.bcxin.runtime.domain.imports.entities.enums.ProcessedStatus;
import com.bcxin.saas.core.IAggregate;
import com.bcxin.saas.core.models.EntityBase;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;
import java.util.Date;
import java.util.UUID;

@Getter
@Setter(AccessLevel.PROTECTED)
@Entity
@Table(name = "import_data_queues")
public class DataQueueEntity extends EntityBase<String> implements IAggregate {
    @Id
    @Column(length = 50)
    private String id;
    @Column(length = 100, nullable = false)
    private String referenceId;
    @Temporal(TemporalType.TIMESTAMP)
    @Column(nullable = false)
    private Date businessDateTime;
    @Column(length = 8000)
    //@Lob
    //mpp数据库不支持
    private String body;
    @Enumerated
    private ProcessedStatus status;
    @Temporal(TemporalType.TIMESTAMP)
    @Column(nullable = false)
    private Date createdTime;
    //@Lob
    //mpp数据库不支持
    @Column(length = 8000)
    private String result;
    @Temporal(TemporalType.TIMESTAMP)
    private Date lastProcessedTime;


    public void changeStatus(ProcessedStatus status, String message) {
        this.setStatus(status);
        this.setResult(result);
        this.setLastProcessedTime(new Date());
    }

    protected DataQueueEntity(){}
    private DataQueueEntity(String referenceId, Date businessDateTime, String body) {
        this.setId(UUID.randomUUID().toString());
        this.setBody(body);
        this.setCreatedTime(new Date());
        this.setBusinessDateTime(businessDateTime);
        this.setReferenceId(referenceId);
        this.setStatus(ProcessedStatus.Initialize);
    }

    public static DataQueueEntity create(String referenceId, Date businessDateTime,String body) {
        return new DataQueueEntity(referenceId, businessDateTime, body);
    }
}
