package com.bcxin.runtime.apis.responses;

import lombok.Getter;
import org.springframework.util.CollectionUtils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;

@Getter
public class UserRoleResponse implements Serializable {
    private final String userId;
    private final Collection<UserAppItem> apps = new ArrayList<>();

    public String getRoleDesc() {
        if (CollectionUtils.isEmpty(apps)) {
            return null;
        }

        return apps.stream().map(ii -> ii.getDesc()).collect(Collectors.joining(";"));
    }

    public UserRoleResponse(String userId) {
        this.userId = userId;
    }

    public static UserRoleResponse create(String userId) {
        return new UserRoleResponse(userId);
    }

    public void assignApps(UserAppItem app) {
        this.getApps().add(app);
    }

    @Getter
    public static class UserAppItem implements Serializable {
        private final String id;
        private final String name;
        private final Collection<UserAppRoleItem> roles = new ArrayList<>();

        public UserAppItem(String id, String name) {
            this.id = id;
            this.name = name;
        }

        public void assignRole(String id, String name) {
            this.getRoles().add(UserAppRoleItem.create(id, name));
        }

        public String getDesc() {
            if(CollectionUtils.isEmpty(this.getRoles())) {
                return null;
            }

            return String.format("【%s】%s", this.getName(),
                    this.getRoles().stream().map(ix->ix.getName()).collect(Collectors.joining(",")));
        }

        public static UserAppItem create(String id, String name) {
            return new UserAppItem(id, name);
        }
    }

    @Getter
    public static class UserAppRoleItem implements Serializable
    {
        private final String id;
        private final String name;

        public UserAppRoleItem(String id, String name) {
            this.id = id;
            this.name = name;
        }

        public static UserAppRoleItem create(String id, String name) {
            return new UserAppRoleItem(id, name);
        }
    }
}
