package com.bcxin.runtime.apis.dtos;

import com.bcxin.runtime.apis.configs.RegionConfig;
import com.bcxin.runtime.apis.requests.DownChangelogRequest;
import com.bcxin.runtime.domain.repositories.syncs.components.impls.SqlParserAbstract;
import com.bcxin.runtime.domain.snapshoots.TableMapSnapshot;
import lombok.Getter;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;

@Getter
public class ChangeLogContext {
    public static final String ISTMP_COLUMN = "ISTMP";
    private final SyncChangeLogTableDto table;
    private final DownChangelogRequest changelogRequest;
    private final RegionConfig.RegionConfigItem selectedRegionConfigItem;
    private final Collection<String> sqlTemplates;

    private ChangeLogContext(SyncChangeLogTableDto table, Collection<String> sqlTemplates,DownChangelogRequest changelogRequest, RegionConfig.RegionConfigItem selectedRegionConfigItem) {
        this.table = table;
        this.changelogRequest = changelogRequest;
        this.selectedRegionConfigItem = selectedRegionConfigItem;
        this.sqlTemplates = sqlTemplates;
    }

    public static ChangeLogContext create(SyncChangeLogTableDto table, Collection<String> sqlTemplates,DownChangelogRequest changelogRequest, RegionConfig.RegionConfigItem selectedRegionConfigItem) {
        return new ChangeLogContext(table,sqlTemplates, changelogRequest, selectedRegionConfigItem);
    }

    public Map<String,Object> getParams(Map<String,Object> dt) {
        if (dt == null) {
            return Collections.emptyMap();
        }

        Collection<TableMapSnapshot.Column> defaultMappingColumns =
                SqlParserAbstract.getTDocumentMapSnapshotTemplate().getColumns();
        if (CollectionUtils.isEmpty(defaultMappingColumns)) {
            for (TableMapSnapshot.Column col : defaultMappingColumns) {
                if (!dt.containsKey(col.getFieldName())) {
                    dt.put(col.getFieldName(), col.getFixedValue() == null ? col.getDefaultValue() : col.getFixedValue());
                }
            }
        }

        if (selectedRegionConfigItem == null) {
            dt.put("dynamic_domain_id", null);
        } else {
            dt.put("dynamic_domain_id", selectedRegionConfigItem.getDomainId());

            Map<String, String> dbNameMaps = selectedRegionConfigItem.getDbMaps();
            if (!CollectionUtils.isEmpty(dbNameMaps)) {
                for (String key : dbNameMaps.keySet()) {
                    String kValue = dbNameMaps.get(key);
                    if (!StringUtils.hasLength(kValue)) {
                        continue;
                    }
                    dt.put(String.format("dynamic_%s", key), kValue);
                }
            }
        }


        if ("public".equalsIgnoreCase(selectedRegionConfigItem.getPrefixId())) {
            Optional<String> keyOptional = dt.keySet().stream().filter(ii -> ii.equalsIgnoreCase("domainId")).findFirst();
            if (keyOptional.isPresent()) {
                dt.put("dynamic_domain_id", dt.get(keyOptional.get()));
            }
        }

        Optional<String> isTmpColumnOptional =
                dt.keySet().stream().filter(ii -> ISTMP_COLUMN.equalsIgnoreCase(ii)).findFirst();
        if (isTmpColumnOptional.isPresent()) {
            Object value = dt.get(isTmpColumnOptional.get());
            if (value != null && ("true".equalsIgnoreCase(String.valueOf(value)) || "1".equalsIgnoreCase(String.valueOf(value)))) {
                value = "1";
            } else {
                value = "0";
            }

            dt.put(isTmpColumnOptional.get(), value);
        }


        if (!CollectionUtils.isEmpty(changelogRequest.getDynamicParameterMaps())) {
            for (String key : changelogRequest.getDynamicParameterMaps().keySet()) {
                String kValue = changelogRequest.getDynamicParameterMaps().get(key);
                dt.put(String.format("dynamic_%s", key), kValue);
            }
        }

        return dt;
    }
}
