package com.bcxin.runtime.apis.configs;

import com.bcxin.runtime.domain.imports.repositories.DataQueueRepository;
import com.bcxin.runtime.domain.messages.repositories.MessageRepository;
import com.bcxin.runtime.domain.repositories.components.DataPermissionScopeProviderImpl;
import com.bcxin.runtime.domain.permissions.repositories.DataPermissionScopeRepository;
import com.bcxin.runtime.domain.repositories.imports.repositories.JpaDataQueueRepository;
import com.bcxin.runtime.domain.repositories.messages.repositories.JpaMessageRepository;
import com.bcxin.runtime.domain.repositories.permissions.repositories.JpaDataPermissionScopeRepository;
import com.bcxin.saas.core.components.*;
import com.bcxin.saas.core.enums.EnvironmentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.util.StringUtils;

import java.util.Collection;
import java.util.List;

@Configuration("com.bcxin.runtime.apis.configs.RuntimeSetupConfig")
@EnableJpaRepositories(basePackages = {
        "com.bcxin.runtime.domain.repositories.messages.repositories",
        "com.bcxin.runtime.domain.repositories.permissions.repositories",
        "com.bcxin.runtime.domain.repositories.imports.repositories",
        "com.bcxin.runtime.domain.repositories.metas.repositories",
        "com.bcxin.runtime.domain.repositories.syncs.repositories",
        "com.bcxin.event.repositories.repositories"
})
@EntityScan(
        basePackages = {
                "com.bcxin.runtime.domain.messages.entities",
                "com.bcxin.runtime.domain.permissions.entities",
        "com.bcxin.runtime.domain.imports.entities",
        "com.bcxin.runtime.domain.metas.entities",
        "com.bcxin.runtime.domain.syncs.entities",
                "com.bcxin.event.entities"}
)
public class RuntimeApiSetupConfig {
    private static final Logger logger = LoggerFactory.getLogger(RuntimeApiSetupConfig.class);

    public RuntimeApiSetupConfig() {
        logger.error("RuntimeSetupConfig 初始化操作");
    }

    @Bean
    public MessageRepository messageRepository(JpaMessageRepository jpaMessageRepository) {
        return jpaMessageRepository;
    }

    @Bean
    public DataPermissionScopeRepository dataPermissionScopeRepository(
            JpaDataPermissionScopeRepository jpaDataPermissionScopeRepository) {
        return jpaDataPermissionScopeRepository;
    }

    @Bean
    public DataPermissionScopeProvider dataPermissionScopeProvider(
            JsonProvider jsonProvider,
            ThreadContextManager threadContextManager,
            DistributedCacheProvider distributedCacheProvider,
            JpaDataPermissionScopeRepository dataPermissionScopeRepository,
            CookieProvider cookieProvider,
            DataPermissionScopeConfig dataPermissionScopeConfig
    ) {


        return new DataPermissionScopeProviderImpl(
                jsonProvider, threadContextManager,
                cookieProvider, distributedCacheProvider,
                dataPermissionScopeRepository, dataPermissionScopeConfig);
    }

    @Bean
    public DataPermissionScopeConfig dataPermissionScopeConfig(
            @Value("${myapps.environment:}") String env,
            @Value("${myapps.dataScope:}") String dataScope,
            @Value("${myapps.conditionAppIds:}") List<String> conditionAppIds
            ) {
        EnvironmentType environmentType = EnvironmentType.Network;

        if ("security".equalsIgnoreCase(env)) {
            environmentType = EnvironmentType.Government_Inner;
        } else if ("security-network".equalsIgnoreCase(env)) {
            environmentType = EnvironmentType.Government_Network;
        }

        DataPermissionScopeConfig config = new DataPermissionScopeConfig(dataScope, conditionAppIds, environmentType);

        return config;
    }

    @Bean
    public DataQueueRepository dataQueueRepository(JpaDataQueueRepository jpaDataQueueRepository) {
        return jpaDataQueueRepository;
    }
}
