package com.bcxin.runtime.apis.configs;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.Map;

@Data
@Configuration
@ConfigurationProperties(prefix = "myapps.region")
public class RegionConfig {
    private String sourceSite;
    private boolean disabled;
    private Map<String, RegionConfigItem> mappings;

    @Data
    public static class RegionConfigItem {
        private String prefixId;
        private String domainId;
        private Map<String, String> dbMaps;

        public String getRealDbName(String bDbName) {
            if (CollectionUtils.isEmpty(this.getDbMaps())) {
                return null;
            }

            return this.getDbMaps().get(bDbName);
        }
    }

    public String getDomainId(String regionCode) {
        if (CollectionUtils.isEmpty(getMappings()) ||
                !StringUtils.hasLength(regionCode)) {
            return null;
        }

        RegionConfigItem configItem = this.getMappings().get(regionCode);
        if (configItem == null) {
            return null;
        }

        return configItem.getDomainId();
    }

    public String getRegionId(String regionCode) {
        RegionConfigItem configItem = getSelectedRegionConfigItem(regionCode);
        if (configItem == null) {
            return null;
        }

        return configItem.getPrefixId();
    }

    public RegionConfigItem getSelectedRegionConfigItem(String regionCode) {
        if (CollectionUtils.isEmpty(getMappings()) ||
                !StringUtils.hasLength(regionCode)) {
            return null;
        }

        if(getMappings().size()==1 && getMappings().get("public")!=null) {
            return getMappings().get("public");
        }

        RegionConfigItem configItem = this.getMappings().get(regionCode);
        if (configItem == null) {
            return null;
        }

        return configItem;
    }
}
