package com.bcxin.sync.apis.responses;
import lombok.Getter;

import java.util.Collection;
import java.util.Date;

@Getter
public class DbDataImportResponse {
    private final Collection<DataSetResult> dataSetResults;
    private final Date time;

    public DbDataImportResponse(Collection<DataSetResult> dataSetResults) {
        this.dataSetResults = dataSetResults;
        this.time = new Date();
    }

    public boolean getIsSuccess() {
        return dataSetResults.stream().allMatch(ii -> ii.isSuccess);
    }

    public static DbDataImportResponse create(Collection<DataSetResult> dataSetResults) {
        return new DbDataImportResponse(dataSetResults);
    }

    @Getter
    public static class DataSetResult {
        private final String id;
        private final boolean isSuccess;
        private final String result;

        public DataSetResult(String id, boolean isSuccess, String result) {
            this.id = id;
            this.isSuccess = isSuccess;
            this.result = result;
        }

        public static DataSetResult create(String id, boolean isSuccess, String result) {
            return new DataSetResult(id, isSuccess, result);
        }
    }
}
