package com.bcxin.sync.apis.controllers;

import com.bcxin.runtime.domain.syncs.commands.CreateFtpDataSyncCommand;
import com.bcxin.runtime.domain.syncs.commands.results.CreateFtpDataSyncCommandResult;
import com.bcxin.runtime.domain.syncs.commands.results.CreateSyncViaFtpCallbackCommandResult;
import com.bcxin.runtime.domain.syncs.dtos.FtpConfigInfoDto;

import com.bcxin.runtime.domain.syncs.services.SyncViaFtpService;
import com.bcxin.saas.core.components.JsonProvider;
import com.bcxin.saas.core.utils.ExceptionUtils;
import com.bcxin.sync.apis.configs.FileModeConfig;
import com.bcxin.sync.apis.requests.SyncViaFtpCallbackRequest;
import com.bcxin.sync.apis.requests.SyncViaFtpDataImportRequest;
import com.bcxin.web.commons.responses.ErrorResponse;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.bcxin.sync.apis.responses.*;

@RestController
@RequestMapping("/v2/sync/ftp")
public class SyncViaFtpController {

    private final SyncViaFtpService syncViaFtpService;
    private final JsonProvider jsonProvider;

    public SyncViaFtpController(SyncViaFtpService syncViaFtpService, JsonProvider jsonProvider) {
        this.syncViaFtpService = syncViaFtpService;
        this.jsonProvider = jsonProvider;
    }


    @PostMapping(value = "/data-import")
    public ResponseEntity post(
            @RequestBody SyncViaFtpDataImportRequest request) {
        StringBuilder sb = new StringBuilder();
        try {
            request.validate();
            CreateFtpDataSyncCommand command = request.getCommand(jsonProvider);
            FtpConfigInfoDto ftpConfigInfoDto = new FtpConfigInfoDto();
            ftpConfigInfoDto.setUseFtp(FileModeConfig.getUseFtp());
            ftpConfigInfoDto.setUserName(FileModeConfig.getUserName());
            ftpConfigInfoDto.setHost(FileModeConfig.getHost());
            ftpConfigInfoDto.setFilePath(FileModeConfig.getFilePath());
            ftpConfigInfoDto.setPassword(FileModeConfig.getPassword());
            ftpConfigInfoDto.setPort(FileModeConfig.getPort());
            CreateFtpDataSyncCommandResult result =
                    this.syncViaFtpService.create(command, ftpConfigInfoDto);
            String savedFileFlag = result.isSavedFileQueued() ? "保存文件队列" : "无文件队列信息";
            String msg = String.format("同步成功(%s)", savedFileFlag);
            sb.append(msg);
            SyncViaFtpDataImportResponse response = SyncViaFtpDataImportResponse.create(true, result.getDataSetResults(), msg);
            return ResponseEntity.ok(response);
        } catch (Exception ex) {

            ErrorResponse error = ErrorResponse.create(sb.toString(), ex);
            SyncViaFtpDataImportResponse errorResponse = SyncViaFtpDataImportResponse.create(false, error, error.getMessage());

            return ResponseEntity.badRequest().body(errorResponse);
        }
    }

    @PostMapping(value = "/callback", consumes = {MediaType.APPLICATION_FORM_URLENCODED_VALUE})
    public ResponseEntity callback(SyncViaFtpCallbackRequest request) {
        StringBuilder sb = new StringBuilder();
        try {
            CreateSyncViaFtpCallbackCommandResult result =
                    syncViaFtpService.create(request.getCommand());

            sb.append("执行成功;");
            SyncViaFtpCallbackResponse response = SyncViaFtpCallbackResponse.create(true, result.getDataId(), "回调成功");
            return ResponseEntity.ok(response);
        } catch (Exception ex) {
            sb.append(String.format("数据导入异常:%s;", ExceptionUtils.getStackMessage(ex)));

            ErrorResponse error = ErrorResponse.create(sb.toString(), ex);
            SyncViaFtpDataImportResponse errorResponse = SyncViaFtpDataImportResponse.create(false, error, error.getMessage());

            return ResponseEntity.badRequest().body(errorResponse);
        }
    }
}
