package com.bcxin.runtime.domain.syncs.entities;

import com.bcxin.runtime.domain.enums.BooleanStatus;
import com.bcxin.saas.core.IAggregate;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;
import java.util.Date;
import java.util.UUID;

@Getter
@Setter(AccessLevel.PROTECTED)
@Entity
@Table(name = "sync_frm_file_queues")
public class FileSyncQueueEntity implements IAggregate {
    @Id
    private String id;
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "created_time", nullable = false)
    private Date createdTime;
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "last_processed_time", nullable = true)
    private Date lastProcessedTime;

    @Column(nullable = false, name = "download_url", length = 800)
    private String downloadUrl;

    @Column(name = "path", length = 500)
    private String path;

    @Column(length = 8000)
    private String result;

    @Column(name = "sync_queue_id", nullable = false)
    private String syncQueueId;

    @Column(name = "sync_log_id", nullable = false)
    private String syncLogId;

    @Column(name = "is_downloaded", nullable = false)
    private BooleanStatus isDownloaded;

    @Column(name = "retry_count", nullable = false)
    private int retryCount;

    public void makeStatus(boolean isSuccess, String msg) {
        this.setLastProcessedTime(new Date());
        this.setIsDownloaded(isSuccess ? BooleanStatus.TRUE : BooleanStatus.FALSE);
        this.setResult(msg);
        this.setRetryCount(this.getRetryCount() + 1);
    }

    protected FileSyncQueueEntity() {

    }

    public FileSyncQueueEntity(String downloadUrl, String path, String syncQueueId, String syncLogId) {
        this.setId(UUID.randomUUID().toString());
        this.setSyncQueueId(syncQueueId);
        this.setSyncLogId(syncLogId);
        this.setDownloadUrl(downloadUrl);
        this.setPath(path);
        this.setCreatedTime(new Date());
        this.setIsDownloaded(BooleanStatus.FALSE);
    }

    public static FileSyncQueueEntity create(String downloadUrl, String path, String syncQueueId, String syncLogId) {
        return new FileSyncQueueEntity(downloadUrl, path, syncQueueId, syncLogId);
    }
}
