package com.bcxin.runtime.domain.metas.commands;

import com.bcxin.runtime.domain.metas.entities.enums.*;
import com.bcxin.saas.core.commands.CommandAbstract;
import com.bcxin.saas.core.exceptions.SaasNoSupportException;
import lombok.Getter;
import lombok.Setter;

import java.util.Collection;
import java.util.Optional;

@Getter
public class RefreshAppCommand extends CommandAbstract {
    private final Collection<Application> applications;
    public RefreshAppCommand(Collection<Application> applications) {
        this.applications = applications;
    }

    @Override
    protected void validate() {
    }

    public static RefreshAppCommand create(Collection<Application> applications) {
        return new RefreshAppCommand(applications);
    }

    public Application matched(String id) {
        if (this.getApplications() == null) {
            return null;
        }

        Optional<Application> application = this.getApplications().stream()
                .filter(ii -> ii.getId().equals(id))
                .findFirst();

        return application.isPresent() ? application.get() : null;
    }

    @Getter
    public static class Application {
        private final String id;
        private final String name;
        private final boolean isOnline;
        private final String note;
        @Setter
        private Collection<DataSource> dataSources;
        @Setter
        private Collection<Form> forms;

        public Application(String id, String name, boolean isOnline, String note) {
            this.id = id;
            this.name = name;
            this.isOnline = isOnline;
            this.note = note;
        }


        public static Application create(String id, String name, boolean isOnline, String note) {
            return new Application(id, name, isOnline, note);
        }
    }

    @Getter
    public static class DataSource {
        private final String id;
        private final String name;
        private final String driverClass;
        private final String useType;
        private final String config;
        private final int dbType;
        private final boolean isSelected;

        public DataSource(String id,String name, String useType, int dbType,String driverClass, String config,boolean isSelected) {
            this.id = id;
            this.name = name;
            this.useType = useType;
            this.driverClass = driverClass;
            this.config = config;
            this.dbType = dbType;
            this.isSelected = isSelected;
        }

        public static DataSource create(String id,String name,  String useType, int dbType,String driverClass, String config,boolean isSelected) {
            return new DataSource(id, name, useType, dbType, driverClass, config, isSelected);
        }

        public DbType getEnumDbType() {
            switch (this.dbType) {
                case 4://cn.myapps.common.model.datasource.DataSource.DB_MYSQL
                    return DbType.Mysql;
                case 1://cn.myapps.common.model.datasource.DataSource.DB_MYSQL
                    return DbType.Oracle;
                case 2://cn.myapps.common.model.datasource.DataSource.DB_MYSQL
                    return DbType.SqlServer;
                case 6://cn.myapps.common.model.datasource.DataSource.DB_MYSQL
                    return DbType.PostgreSql;
                case 5://cn.myapps.common.model.datasource.DataSource.DB_MYSQL
                    return DbType.HSQL;
                case 7://cn.myapps.common.model.datasource.DataSource.DB_MYSQL
                    return DbType.DM;
                case 3://cn.myapps.common.model.datasource.DataSource.DB_MYSQL
                    return DbType.DB2;
                default:
                    throw new SaasNoSupportException();
            }
        }

        public UseType getEnumDriveType() {
            if ("JDBC".equals(this.useType)) {
                return UseType.JDBC;
            } else {
                return UseType.JNDI;
            }
        }
    }

    @Getter
    public static class Form {
        private final String id;
        private final String name;
        private final String tableName;
        private final FormType formType;

        public Form(String id, String name, String tableName, FormType formType) {
            this.id = id;
            this.name = name;
            this.tableName = tableName;
            this.formType = formType;
        }

        public static Form create(String id, String name, String tableName, FormType formType) {
            return new Form(id, name, tableName, formType);
        }
    }
}
