package com.bcxin.runtime.domain.messages.entities;

import com.bcxin.runtime.domain.messages.enums.ProcessesStatus;
import com.bcxin.saas.core.IAggregate;
import com.bcxin.saas.core.components.JsonProvider;
import com.bcxin.saas.core.enums.*;
import com.bcxin.saas.core.exceptions.SaasNoSupportException;
import com.bcxin.saas.core.models.EntityBase;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;
import org.apache.commons.lang3.StringUtils;

import javax.persistence.*;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.UUID;

/**
 * 站内消息
 */
@Getter
@Setter(AccessLevel.PROTECTED)
@Entity
@Table(name = "shared_messages")
public class MessageEntity extends EntityBase<String> implements IAggregate {
    @Id
    @Column(length = 50)
    private String id;

    @Column(name = "title", length = 500)
    private String title;

    @Column(name = "content", nullable = false,length = 5000)
    private String content;

    @Column(name = "parameter_json",length = 2000)
    private String parameterJson;

    @Column(name = "sender_id", nullable = false,length = 100)
    private String senderId;

    @Column(name = "receiver", nullable = false,length = 100)
    private String receiver;

    @Column(name = "message_type", nullable = false)
    private MessageType messageType;

    @Column(name = "receiver_type", nullable = false)
    private ReceiverType receiverType;

    @Column(name = "status", nullable = false)
    private ProcessesStatus status;

    @Column(name = "created_time", nullable = false)
    private Timestamp createdTime;

    @Column(name = "last_processed_time")
    private Timestamp lastProcessedTime;

    @Column(name = "business_number",length = 500)
    private String businessNumber;

    @Column(name = "unique_id",nullable = false,length = 200)
    private String uniqueId;

    protected MessageEntity(){}

    protected MessageEntity(String senderId,
                            MessageType messageType,
                            String title,
                            String content,
                            ReceiverType receiverType,
                            String receiver,
                            Object parameter,
                            String uniqueId,
                            JsonProvider jsonProvider) {
        this.setId(UUID.randomUUID().toString());
        this.setMessageType(messageType);
        this.setContent(content);
        this.setReceiverType(receiverType);
        this.setReceiver(receiver);
        this.setSenderId(senderId);
        this.setParameterJson(jsonProvider.getJson(parameter));
        this.setCreatedTime(Timestamp.from(Instant.now()));
        this.setStatus(ProcessesStatus.Init);
        this.setTitle(title);

        if (StringUtils.length(uniqueId) > 0) {
            this.setUniqueId(uniqueId);
        } else {
            this.setUniqueId(this.getId());
        }
    }

    public void assignBusinessNumber(String businessNumber) {
        if (StringUtils.length(this.getBusinessNumber()) > 0) {
            throw new SaasNoSupportException(String.format("无法对已经存在的消息进行BusinessNumber的变更"));
        }

        this.setBusinessNumber(businessNumber);
    }

    public static MessageEntity create(String senderId,
                                       MessageType messageType,
                                       String title,
                                       String content,
                                       ReceiverType receiverType,
                                       String receiver,
                                       Object parameter,
                                       String uniqueId,
                                       JsonProvider jsonProvider) {
        return new MessageEntity(
                senderId, messageType,
                title,
                content, receiverType, receiver, parameter,
                uniqueId,
                jsonProvider);
    }
}
