package com.bcxin.runtime.domain.repositories.permissions.repositories;

import com.bcxin.runtime.domain.permissions.entities.DataPermissionScopeEntity;
import com.bcxin.runtime.domain.permissions.repositories.DataPermissionScopeRepository;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import java.util.Collection;

public interface JpaDataPermissionScopeRepository extends JpaRepository<DataPermissionScopeEntity,String>,DataPermissionScopeRepository {

    @Query(value = "select * from tenant_data_permissions x where exists(select 1 from tenant_department_employee_relations d where concat( 'dpt_', d.department_index_tree ) like CONCAT(x.search_index_code,'%') and d.employee_id=:employeeId) order by x.search_index_code desc  limit 1", nativeQuery = true)
    DataPermissionScopeEntity getPermissionScopesByEmployeeId(String employeeId);

    @Query(value = "select * from tenant_data_permissions x where exists(select 1 from t_supervise_department d where concat( 'seg_', d.index_code ) like CONCAT(x.search_index_code,'%') and d.id=:organizationId) order by x.search_index_code desc limit 1", nativeQuery = true)
    DataPermissionScopeEntity getPermissionScopesBySecurityOrgId(String organizationId);
}
