package com.bcxin.common.apis.configs;

import cn.myapps.common.util.PropertyUtil;
import com.bcxin.common.apis.filter.MultiLanguageFilter;
import com.bcxin.saas.core.components.DistributedCacheProvider;
import com.bcxin.sync.apis.interceptor.FileModeDownloadInterceptor;
import com.bcxin.web.commons.components.RedisDistributedCacheProviderImpl;
import org.redisson.api.RedissonClient;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
public class MyappsMvcConfig extends WebMvcConfigurerAdapter {

	@Bean
	public CommonsMultipartResolver multipartResolver() {
		CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver();
		multipartResolver.setMaxUploadSize(-1);// 不限制上传文件大小
		return multipartResolver;
	}

	@Override
	public void addResourceHandlers(ResourceHandlerRegistry registry) {
		registry.addResourceHandler("/**").addResourceLocations("classpath:/static/").addResourceLocations("/");
		String uploadsFolderPath = PropertyUtil.getPath() + "/uploads/";
		registry.addResourceHandler("/uploads/**")
				.addResourceLocations("file:///" + uploadsFolderPath);

		super.addResourceHandlers(registry);
	}

	@Override
	public void addInterceptors(InterceptorRegistry registry) {
		super.addInterceptors(registry);
		System.err.println("good girl, this is MyappsMvcConfig.java =====AAA");

		registry.addInterceptor(new FileModeDownloadInterceptor()).addPathPatterns("/uploads/**");
//		registry.addInterceptor(new FileModeDownloadInterceptor()).addPathPatterns("/upload/**");
	}

	@Bean
	public FilterRegistrationBean filterRegistrationBean3() {
		FilterRegistrationBean bean = new FilterRegistrationBean();
		bean.setFilter(new MultiLanguageFilter());
		bean.addUrlPatterns("/api/runtime/*");
		return bean;
	}

	@Bean
	public DistributedCacheProvider distributedCacheProvider(RedisTemplate redisTemplate, RedissonClient redissonClient) {
		redisTemplate.setKeySerializer(new StringRedisSerializer());
		redisTemplate.setValueSerializer(new StringRedisSerializer());
		return new RedisDistributedCacheProviderImpl(redisTemplate, redissonClient);
	}
}
