/*
 * Decompiled with CFR 0.152.
 */
package cn.wildfirechat.sdk.utilities;

import cn.wildfirechat.sdk.model.IMResult;
import cn.wildfirechat.sdk.utilities.JsonUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.netty.util.internal.StringUtil;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RobotHttpUtils
extends JsonUtils {
    private static final Logger LOG = LoggerFactory.getLogger(RobotHttpUtils.class);
    public static final Gson gson = new GsonBuilder().disableHtmlEscaping().create();
    private final String url;
    private final String robotId;
    private final String robotSecret;
    private final CloseableHttpClient httpClient;
    private final int port;

    private void checkPort() {
        if (this.port != 80 && this.port != 443) {
            if (this.port == 18080) {
                LOG.warn("\u60a8\u4f20\u5165\u7684\u673a\u5668\u4ebaAPI\u5730\u5740\u4e2d\u7684\u7aef\u53e3\u662f18080\uff0c18080\u7aef\u53e3\u9ed8\u8ba4\u4e3a\u7ba1\u7406API\u7aef\u53e3\uff0c\u673a\u5668\u4ebaAPI\u7aef\u53e3\u5e94\u8be5\u4e3aIM\u670d\u52a1\u7684HTTP\u7aef\u53e3\uff0c\u9ed8\u8ba4\u4e3a80\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u4f7f\u7528\u9519\u8bef\uff01");
            } else {
                LOG.warn("\u60a8\u4f20\u5165\u7684\u673a\u5668\u4ebaAPI\u5730\u5740\u4e2d\u7684\u7aef\u53e3\u4e0d\u662f80/443\uff0c\u673a\u5668\u4ebaAPI\u7684\u7aef\u53e3\u548c\u5ba2\u6237\u7aef\u4f7f\u7528\u7aef\u53e3\u4e00\u6837\uff0c\u90fd\u5e94\u8be5\u4e3aIM\u670d\u52a1\u7684HTTP\u7aef\u53e3\uff0c\u9ed8\u8ba4\u4e3a80\uff0c\u8bf7\u786e\u5b9e\u662f\u5426\u6b63\u786e\uff1f\u5982\u679c\u60a8\u5b9a\u5236\u5316\u4e86IM\u670d\u52a1\u7aef\u53e3\u6216\u8005\u4f7f\u7528\u5176\u4ed6\u7aef\u53e3\u53cd\u5411\u4ee3\u7406IM\u670d\u52a1\u7684HTTP\u7aef\u53e3\u8bf7\u5ffd\u7565\u6b64\u63d0\u793a\u3002");
            }
        }
    }

    public RobotHttpUtils(String url, String robotId, String robotSecret) {
        this.url = url.trim();
        this.robotId = robotId.trim();
        this.robotSecret = robotSecret.trim();
        try {
            URL u = new URL(this.url);
            this.port = u.getPort();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        this.checkPort();
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.setValidateAfterInactivity(1000);
        int connectTimeout = 5000;
        int socketTimeout = 15000;
        int connectionRequestTimeout = 3000;
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(connectTimeout).setSocketTimeout(socketTimeout).setConnectionRequestTimeout(connectionRequestTimeout).build();
        this.httpClient = HttpClients.custom().setDefaultRequestConfig(requestConfig).setConnectionManager((HttpClientConnectionManager)cm).evictExpiredConnections().evictIdleConnections(60L, TimeUnit.SECONDS).setRetryHandler((HttpRequestRetryHandler)DefaultHttpRequestRetryHandler.INSTANCE).setMaxConnTotal(100).setMaxConnPerRoute(50).build();
    }

    public <T> IMResult<T> httpJsonPost(String path, Object object, Class<T> clazz) throws Exception {
        if (RobotHttpUtils.isNullOrEmpty(this.url) || RobotHttpUtils.isNullOrEmpty(path)) {
            LOG.error("Not init IM SDK correctly. Do you forget init it?");
            throw new Exception("SDK url or secret lack!");
        }
        String url = this.url + path;
        HttpPost post = null;
        try {
            String line;
            CloseableHttpResponse response;
            int statusCode;
            int nonce = (int)(Math.random() * 100000.0 + 3.0);
            long timestamp = System.currentTimeMillis();
            String str = nonce + "|" + this.robotSecret + "|" + timestamp;
            String sign = DigestUtils.sha1Hex((String)str);
            post = new HttpPost(url);
            post.setHeader("Content-type", "application/json; charset=utf-8");
            post.setHeader("Connection", "Keep-Alive");
            post.setHeader("nonce", nonce + "");
            post.setHeader("timestamp", "" + timestamp);
            post.setHeader("rid", this.robotId);
            post.setHeader("sign", sign);
            String jsonStr = null;
            if (object != null) {
                jsonStr = gson.toJson(object);
            }
            LOG.info("http request:{} content: {}", (Object)url, (Object)jsonStr);
            if (!StringUtil.isNullOrEmpty((String)jsonStr)) {
                StringEntity entity = new StringEntity(jsonStr, Charset.forName("UTF-8"));
                entity.setContentEncoding("UTF-8");
                entity.setContentType("application/json");
                post.setEntity((HttpEntity)entity);
            }
            if ((statusCode = (response = this.httpClient.execute((HttpUriRequest)post)).getStatusLine().getStatusCode()) != 200) {
                LOG.info("Request error: " + statusCode);
                throw new Exception("Http request error with code:" + statusCode);
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), "utf-8"));
            StringBuffer sb = new StringBuffer();
            String NL = System.getProperty("line.separator");
            while ((line = in.readLine()) != null) {
                sb.append(line + NL);
            }
            in.close();
            String content = sb.toString();
            LOG.info("http request response content: {}", (Object)content);
            IMResult<T> iMResult = RobotHttpUtils.fromJsonObject(content, clazz);
            return iMResult;
        }
        catch (Exception e) {
            this.checkPort();
            e.printStackTrace();
            throw e;
        }
        finally {
            if (post != null) {
                post.releaseConnection();
            }
        }
    }

    public String getRobotId() {
        return this.robotId;
    }

    public String getRobotSecret() {
        return this.robotSecret;
    }
}

