/*
 * Decompiled with CFR 0.152.
 */
package cn.wildfirechat.sdk.messagecontent;

import cn.wildfirechat.pojos.MessagePayload;
import cn.wildfirechat.sdk.messagecontent.MessageContent;
import io.netty.util.internal.StringUtil;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class RichNotificationMessageContent
extends MessageContent {
    private String title;
    private String desc;
    private String remark;
    private JSONArray datas;
    private String exName;
    private String exPortrait;
    private String exUrl;
    private String appId;

    public RichNotificationMessageContent() {
    }

    public RichNotificationMessageContent(String title, String desc, String exUrl) {
        this.title = title;
        this.desc = desc;
        this.exUrl = exUrl;
    }

    public RichNotificationMessageContent title(String title) {
        this.title = title;
        return this;
    }

    public RichNotificationMessageContent desc(String desc) {
        this.desc = desc;
        return this;
    }

    public RichNotificationMessageContent exUrl(String exUrl) {
        this.exUrl = exUrl;
        return this;
    }

    public RichNotificationMessageContent remark(String remark) {
        this.remark = remark;
        return this;
    }

    public RichNotificationMessageContent exName(String exName) {
        this.exName = exName;
        return this;
    }

    public RichNotificationMessageContent exPortrait(String exPortrait) {
        this.exPortrait = exPortrait;
        return this;
    }

    public RichNotificationMessageContent appId(String appId) {
        this.appId = appId;
        return this;
    }

    public RichNotificationMessageContent addItem(String key, String value) {
        return this.addItem(key, value, null);
    }

    public RichNotificationMessageContent addItem(String key, String value, String color) {
        if (this.datas == null) {
            this.datas = new JSONArray();
        }
        JSONObject item = new JSONObject();
        item.put((Object)"key", (Object)key);
        item.put((Object)"value", (Object)(value == null ? "" : value));
        if (!StringUtil.isNullOrEmpty((String)color)) {
            item.put((Object)"color", (Object)color);
        }
        this.datas.add((Object)item);
        return this;
    }

    @Override
    public int getContentType() {
        return 12;
    }

    @Override
    public int getPersistFlag() {
        return 3;
    }

    @Override
    public MessagePayload encode() {
        MessagePayload payload = super.encode();
        payload.setPushContent(this.title);
        payload.setContent(this.desc);
        JSONObject jsonObject = new JSONObject();
        if (!StringUtil.isNullOrEmpty((String)this.remark)) {
            jsonObject.put((Object)"remark", (Object)this.remark);
        }
        if (!StringUtil.isNullOrEmpty((String)this.exName)) {
            jsonObject.put((Object)"exName", (Object)this.exName);
        }
        if (!StringUtil.isNullOrEmpty((String)this.exPortrait)) {
            jsonObject.put((Object)"exPortrait", (Object)this.exPortrait);
        }
        if (!StringUtil.isNullOrEmpty((String)this.exUrl)) {
            jsonObject.put((Object)"exUrl", (Object)this.exUrl);
        }
        if (!StringUtil.isNullOrEmpty((String)this.appId)) {
            jsonObject.put((Object)"appId", (Object)this.appId);
        }
        if (this.datas != null && !this.datas.isEmpty()) {
            jsonObject.put((Object)"datas", (Object)this.datas);
        }
        payload.setBase64edData(Base64.getEncoder().encodeToString(jsonObject.toJSONString().getBytes(StandardCharsets.UTF_8)));
        return payload;
    }

    @Override
    public void decode(MessagePayload payload) {
        super.decode(payload);
    }
}

