/*
 * Decompiled with CFR 0.152.
 */
package cn.wildfirechat.pojos;

import cn.wildfirechat.proto.WFCMessage;
import io.netty.util.internal.StringUtil;
import java.util.ArrayList;
import java.util.List;

public class PojoChannelMenu {
    public String menuId;
    public String type;
    public String name;
    public String key;
    public String url;
    public String mediaId;
    public String articleId;
    public String appId;
    public String appPage;
    public String extra;
    public List<PojoChannelMenu> subMenus;

    public static PojoChannelMenu fromPbInfo(WFCMessage.ChannelMenu channelMenuMenu) {
        PojoChannelMenu out = new PojoChannelMenu();
        out.menuId = channelMenuMenu.getMenuId();
        out.type = channelMenuMenu.getType();
        out.name = channelMenuMenu.getName();
        out.key = channelMenuMenu.getKey();
        out.url = channelMenuMenu.getUrl();
        out.mediaId = channelMenuMenu.getMediaId();
        out.articleId = channelMenuMenu.getArticleId();
        out.appId = channelMenuMenu.getAppId();
        out.appPage = channelMenuMenu.getAppPage();
        out.extra = channelMenuMenu.getExtra();
        if (channelMenuMenu.getSubMenuCount() > 0) {
            out.subMenus = new ArrayList<PojoChannelMenu>();
            for (WFCMessage.ChannelMenu menuMenu : channelMenuMenu.getSubMenuList()) {
                out.subMenus.add(PojoChannelMenu.fromPbInfo(menuMenu));
            }
        }
        return out;
    }

    public WFCMessage.ChannelMenu.Builder toPbInfo() {
        WFCMessage.ChannelMenu.Builder builder = WFCMessage.ChannelMenu.newBuilder();
        builder.setType(this.type);
        builder.setName(this.name);
        if (!StringUtil.isNullOrEmpty((String)this.menuId)) {
            builder.setMenuId(this.menuId);
        }
        if (!StringUtil.isNullOrEmpty((String)this.key)) {
            builder.setKey(this.key);
        }
        if (!StringUtil.isNullOrEmpty((String)this.url)) {
            builder.setUrl(this.url);
        }
        if (!StringUtil.isNullOrEmpty((String)this.mediaId)) {
            builder.setMediaId(this.mediaId);
        }
        if (!StringUtil.isNullOrEmpty((String)this.articleId)) {
            builder.setArticleId(this.articleId);
        }
        if (!StringUtil.isNullOrEmpty((String)this.appId)) {
            builder.setAppId(this.appId);
        }
        if (!StringUtil.isNullOrEmpty((String)this.appPage)) {
            builder.setAppPage(this.appPage);
        }
        if (!StringUtil.isNullOrEmpty((String)this.extra)) {
            builder.setExtra(this.extra);
        }
        if (this.subMenus != null && !this.subMenus.isEmpty()) {
            this.subMenus.forEach(menuMenu -> builder.addSubMenu(menuMenu.toPbInfo()));
        }
        return builder;
    }
}

