import React, { Component } from "react";
import { Input, Icon, Radio, Checkbox } from "antd";
import "./index.less";
import {
  getTreeperBydepart,
  getDepartPersonList,
  getHuaweiDepartPersonList,
  getDepartmentData,
  getPerListByKeyword,
  getHuaweiPerListByKeyword
} from "../../services/api";
// import list from '../../models/list';

const { Search } = Input;
const RadioGroup = Radio.Group;

class GetUser extends Component {
  selectedDepartId = []; //已经加载过人员的数据
  // alluser=[]
  constructor(props, context) {
    super(props, context);
    this.state = {
      //这里是不需要改的参数
      searchvalue: "",
      radiovalue: this.props.value || "",
      type: this.props.type || "checkbox",
      visible: false,
      currentTree: [],
      navtree: [{ title: "", key: "all", children: [] }], //公司信息
      huaweiMeeting: this.props.huaweiMeeting || false,
      //这里是原本的数据
      checkboxValueArr: this.props.value || [],
      alluser: this.allUser,

      //这里是新的数据
      currentDepartId: "", //当前选中的部门的key值
      // currentDepartTotalNumber: null,//当前部门人数总条数
      currentUserNumber: 0, //当前展示的人员条数
      formSearch: {
        pageNumber: 1,
        pageSize: 10
      },
      // userList: [],
      defaultArrayObj: this.props.defaultArrayObj || null, //初始选中的是哪条默认值
      searchList: this.searchList, //搜索到的列表
      searchPageNumber: 1,
      searchPageSize: 10,
      searchTotal: null, //搜索到的总的值
      searchValue: [],
      searchRadiovalue: "",
      arrayObj: this.props.defaultArrayObj || null //选中那些
      // arrayObj:  null //选中那些
    };
    this.saveRef = ref => {
      this.refDom = ref;
    };
  }

  componentDidMount() {
    // this.getPersonData();
    this.getPartList(); //---获取部门列表数据
  }
  componentWillReceiveProps(nextProps) {
    if (nextProps.value instanceof Array) {
      this.setState({ checkboxValueArr: nextProps.value });
      if (nextProps.value !== this.state.checkboxValueArr) {
        this.propsOnselect(nextProps.value);
      }
    }

    if (nextProps.visible !== this.state.visible) {
      this.setState({ visible: nextProps.visible });
    }

    if (nextProps.visible) {
      this.setState({ searchvalue: "" });
    }

    if (typeof nextProps.value === "string") {
      this.setState({ radiovalue: nextProps.value });
      // this.propsOnselect(nextProps.value);
      // if (nextProps.value !== this.state.radiovalue) {
      //   this.propsOnselect(nextProps.value);
      // }
    }
  }
  //---获取部门列表数据
  getPartList() {
    getDepartmentData().then(res => {
      if (res.retType === "0" && res.data) {
        this.initData(res.data);
        const val =
          this.state.type === "checkbox"
            ? this.state.checkboxValueArr
            : this.state.radiovalue;
        this.propsOnselect(val);
      }
    });
  }

  //--初始化数据
  initData = data => {
    if (data.length > 0) {
      const ret = data;
      this.getDepartUser(ret[0]["key"]);
      this.setState({
        currentDepartId: ret[0]["key"],
        currentTree: ret[0]["children"],
        navtree: [
          {
            title: ret[0]["title"],
            key: ret[0]["key"],
            children: ret[0]["children"]
          }
        ]
      });
    }
  };
  allUser = [];
  //--获取部门人员
  getDepartUser(id, more) {
    let portPromise = null;
    if (this.state.huaweiMeeting) {
      portPromise = getHuaweiDepartPersonList({
        departId: id,
        ...this.state.formSearch
      });
    } else {
      portPromise = getDepartPersonList({
        departId: id,
        ...this.state.formSearch
      });
    }
    if (this.selectedDepartId.indexOf(id) === -1) {
      //没有存在
      this.selectedDepartId.push(id);
      portPromise.then(res => {
        const data = res.data.data;
        for (let i = 0; i < data.length; i++) {
          this.allUser.push({
            ...data[i],
            departId: id,
            totalUser: res.data.total
          });
        }
        this.setState({
          allUser: this.allUser
          // currentDepartTotalNumber: res.data.total
        });
      });
    } else if (more === "seeMore") {
      //有存在但是是查看更多的时候
      portPromise.then(res => {
        const data = res.data.data;
        for (let i = 0; i < data.length; i++) {
          this.allUser.push({
            ...data[i],
            departId: id,
            totalUser: res.data.total
            // total:res.data.total,//用这个总长度来计算要不要显示加载更多
          });
        }
        this.setState({
          allUser: this.allUser
          // currentDepartTotalNumber: res.data.total
        });
      });
    }
  }
  searchList = [];
  //--通过输入关键字搜索到的列表
  _getPerListByKeyword(param) {
    let portPromise = null;
    if (this.state.huaweiMeeting) {
      portPromise = getHuaweiPerListByKeyword({
        keyword: this.state.searchvalue,
        pageNumber: this.state.searchPageNumber,
        pageSize: this.state.searchPageSize
      });
    } else {
      portPromise = getPerListByKeyword({
        keyword: this.state.searchvalue,
        pageNumber: this.state.searchPageNumber,
        pageSize: this.state.searchPageSize
      });
    }
    portPromise.then(res => {
      const data = res.data.data;
      if (res.retType === "0") {
        if (param === "seeMore") {
        } else {
          this.searchList = [];
        }
        for (let i = 0; i < data.length; i++) {
          this.searchList.push({
            ...data[i]
          });
        }
      }
      this.setState({
        searchList: this.searchList,
        searchTotal: res.data.total
      });
    });
  }
  /* 暂无人员 */
  nobody = () => {
    return <div className="nobody">暂无结果</div>;
  };
  // ---默认选中的人员信息
  propsOnselect = (value, param = "") => {
    let arrayObj = [];
    // if (this.state.defaultArrayObj) {
    //   if(this.state.defaultArrayObj instanceof Array){
    //     this.state.defaultArrayObj.forEach(val=>{
    //       arrayObj.push({ ...val });
    //       value.push(val.perId)
    //     })
    //   }else{
    //     // value=this.state.defaultArrayObj.perId
    //     //  arrayObj.push({ ...this.state.defaultArrayObj });
    //   }
    // }
    if (param === "") {
      if (value instanceof Array) {
        //是复选框
        let allList = this.state.arrayObj || [];
        this.state.alluser.length > 0 &&
          this.state.alluser.forEach(val => {
            if (this.state.arrayObj.length > 0) {
              if (
                JSON.stringify(this.state.arrayObj).indexOf(val.perId) === -1
              ) {
                allList.push(val);
              }
            } else {
              allList = JSON.parse(JSON.stringify(this.state.alluser));
            }
          });
        value.forEach(val => {
          const ret = allList.find(val1 => {
            return val1.perId === val;
          });
          if (ret) {
            arrayObj.push(ret);
          }
        });
      } else {
        //是单选框
        const ret = this.allUser.find(val1 => {
          return val1.perId === value;
        });
        if (ret) {
          arrayObj.splice(0, arrayObj.length);
          arrayObj.push(ret);
        }
      }
    } else if (param === "search") {
      if (value instanceof Array) {
        let allList = this.state.arrayObj || [];
        this.state.searchList.length > 0 &&
          this.state.searchList.forEach(val => {
            if (this.state.arrayObj.length > 0) {
              if (
                JSON.stringify(this.state.arrayObj).indexOf(val.perId) === -1
              ) {
                allList.push(val);
              }
            } else {
              allList = this.state.searchList;
            }
          });
        value.forEach(val => {
          // const ret = this.state.searchList.find(val1 => {
          const ret = allList.find(val1 => {
            return val1.perId === val;
          });
          if (ret) {
            arrayObj.push(ret);
          }
        });
      } else {
        const ret = this.state.searchList.find(val1 => {
          return val1.perId === value;
        });
        if (ret) {
          arrayObj.splice(0, arrayObj.length);
          arrayObj.push(ret);
        }
      }
    }
    this.setState({ arrayObj });
    this.props.onSelect(value, arrayObj);
  };

  // /* 遍历所有人员用做搜索 */
  // generatorAllUser = data => {
  //   data.forEach(val => {
  //     if (val.treeType === '2') {
  //       if (this.allUser.indexOf(val) === -1) {
  //         this.allUser.push(val);
  //       } else {
  //         console.log(val, 'generatorAllUser');
  //       }
  //     }
  //     if (val.treeType === '1') {
  //       if (val.children !== null) {
  //         this.generatorAllUser(val.children);
  //       }
  //     }
  //   });
  // };

  //面包屑（显示公司名--第一级）
  renderNavBar = () => {
    const { navtree } = this.state;
    return (
      <div className="nav-partment" ref="navPartment" id="s">
        {navtree.map((val, index) => {
          if (navtree.length - 1 !== index) {
            return (
              <span
                key={index}
                onClick={e => {
                  const alluser = this.state.alluser.slice();
                  let number = 0; //显示的条数
                  const userlist = alluser.map(val => {
                    if (navtree[index].key === val.departId) {
                      number = number + 1;
                    }
                  });
                  const navtreenew = navtree.slice(0, index + 1);
                  this.setState({
                    currentDepartId: navtree[index].key,
                    navtree: navtreenew,
                    currentTree: val.children,
                    formSearch: {
                      ...this.state.formSearch,
                      pageNumber: number !== 0 ? Math.ceil(number / 10) : 1
                    }
                  });
                }}
                className="nav"
              >
                {val.title}
                <Icon type="right" />
              </span>
            );
          }
          return <span key={index}>{val.title}</span>;
        })}
      </div>
    );
  };
  /* 搜索单选框-----------*/
  rendeSearchRadio = () => {
    // const userlist = this.state.alluser.filter(val => {
    const userlist = this.state.searchList.filter(val => {
      const param = val;
      // if (val.name.indexOf(this.state.searchvalue) !== -1) {
      param.show = "block";
      // } else {
      //   param.show = 'none';
      // }
      return param;
    });
    if (
      userlist.some(val => {
        return val.show === "block";
      })
    ) {
      return (
        <div>
          <RadioGroup
            onChange={e => {
              const arr = [];
              const value = JSON.parse(e.target.value);
              arr.push(value);
              this.setState({
                searchRadiovalue: e.target.value,
                searchValue: arr
              });
              this.propsOnselect(value.perId, "search");
            }}
            value={this.state.searchRadiovalue}
          >
            {userlist.map((val, index) => {
              // if (val.treeType === '2') {
              return (
                <Radio
                  key={index}
                  style={{ display: val.show }}
                  className="radioStyle"
                  value={JSON.stringify(val)}
                >
                  <i className="usericon" />
                  {val.name}
                  {val.idCardNo ? "(" + val.idCardNo + ")" : ""}
                </Radio>
              );
              // }
              // return '';
            })}
            <Radio
              style={{ display: "none" }}
              key="null"
              className="radioStyle"
              value="null"
            >
              无值
            </Radio>
          </RadioGroup>
          <div style={{ textAlign: "center", color: "#0f71ff" }}>
            <a
              style={{
                display:
                  userlist.length > 0
                    ? userlist.length < this.state.searchTotal
                      ? "block"
                      : "none"
                    : ""
              }}
              onClick={() => {
                this.setState(
                  {
                    searchPageNumber: this.state.searchPageNumber + 1
                  },
                  () => {
                    this._getPerListByKeyword("seeMore");
                  }
                );
              }}
            >
              点击加载更多...
            </a>
          </div>
        </div>
      );
    } else {
      return this.nobody();
    }
  };
  //搜索复选框
  renderSearchChecked = () => {
    let allList = this.state.arrayObj || [];
    this.state.searchList.length > 0 &&
      this.state.searchList.forEach(val => {
        if (this.state.arrayObj.length > 0) {
          if (JSON.stringify(this.state.arrayObj).indexOf(val.perId) === -1) {
            allList.push(val);
          }
        } else {
          allList = this.state.searchList;
        }
      });
    const userlist = allList.map(val => {
      const param = { ...val };
      param.show = "none";
      this.state.searchList.forEach(val2 => {
        if (val2.perId === val.perId) {
          param.show = "block";
        }
      });
      return param;
    });
    if (
      userlist.some(val => {
        return val.show === "block";
      })
    ) {
      return (
        <Checkbox.Group
          onChange={value => {
            this.setState({ checkboxValueArr: value }, () => {
              this.propsOnselect(value, "search");
            });
          }}
          value={this.state.checkboxValueArr}
        >
          {userlist.map((val, index) => {
            // if (val.treeType === '2') {
            return (
              <Checkbox
                style={{ display: val.show }}
                key={val.perId}
                className="radioStyle"
                value={val.perId}
              >
                <i className="usericon" />
                {val.name}
                {val.idCardNo ? "(" + val.idCardNo + ")" : ""}
              </Checkbox>
            );
            // }
            // return '';
          })}
        </Checkbox.Group>
      );
    } else {
      return this.nobody();
    }
  };

  /* ---无搜索（展示部门信息） */
  renderDepartment = () => {
    return (
      this.state.currentTree &&
      this.state.currentTree.map((val, index) => {
        // if (val.treeType === '1') {
        return (
          <div key={index} className="department-item">
            <i className="departmenticon" />
            <span
              style={{
                overflow: "hidden",
                textOverflow: "ellipsis",
                whiteSpace: "nowrap",
                width: "160px",
                display: "inline-block",
                height: "36px"
              }}
              title={val.title}
            >
              {val.title}
            </span>
            <span
              onClick={() => {
                let number = 0; //显示的条数
                const userlist = this.state.alluser.map(val1 => {
                  if (val.key === val1.departId) {
                    number = number + 1;
                  }
                });

                const navtree = this.state.navtree.slice();
                navtree.push({
                  title: val.title,
                  key: val.key,
                  children: val.children
                });
                this.setState(
                  {
                    currentDepartId: val.key,
                    currentTree: val.children ? val.children : [],
                    navtree,
                    formSearch: {
                      ...this.state.formSearch,
                      pageNumber: number !== 0 ? Math.ceil(number / 10) : 1
                    }
                  },
                  () => {
                    this.getDepartUser(val.key);
                  }
                );
              }}
              className="lower"
            >
              <i className="lowevericon" />
              下级
            </span>
          </div>
        );
        // }
        // return '';
      })
    );
  };
  //单选框
  renderRadio = () => {
    // const currentTree = this.state.currentTree.slice();
    const alluser = this.state.alluser.slice();
    // const alluser = this.alluser
    let number = 0; //显示的条数
    let totalUser = 0;
    const userlist = alluser.map(val => {
      const param = val;
      param.show = "none";
      if (this.state.currentDepartId === val.departId) {
        param.show = "block";
        totalUser = val.totalUser;
        number = number + 1;
        // this.setState({
        //   currentUserNumber:number+1
        // })
      }
      return param;
    });
    return (
      <div>
        <RadioGroup
          onChange={e => {
            this.setState({ radiovalue: e.target.value });
            this.propsOnselect(e.target.value);
          }}
          value={this.state.radiovalue}
        >
          {userlist.map((val, index) => {
            return (
              <Radio
                style={{ display: val.show === "block" ? val.show : "none" }}
                key={index}
                className="radioStyle"
                value={val.perId}
              >
                <i className="usericon" />
                {val.name}
                {val.idCardNo ? "(" + val.idCardNo + ")" : ""}
              </Radio>
            );
          })}
          <Radio
            style={{ display: "none" }}
            key="null"
            className="radioStyle"
            value="null"
          >
            无值
          </Radio>
        </RadioGroup>
        <div>
          <a
            style={{
              textAlign: "center",
              color: "#0f71ff",
              display:
                userlist.length > 0
                  ? number < totalUser
                    ? "block"
                    : "none"
                  : "none"
            }}
            onClick={() => {
              this.setState(
                {
                  formSearch: {
                    ...this.state.formSearch,
                    pageNumber: this.state.formSearch.pageNumber + 1
                  }
                },
                () => {
                  this.getDepartUser(this.state.currentDepartId, "seeMore");
                }
              );
            }}
          >
            点击加载更多...
          </a>
        </div>
      </div>
    );
  };
  //复选框
  renderChecked = () => {
    let allList = JSON.parse(JSON.stringify(this.state.alluser)) || [];
    this.state.arrayObj &&
      this.state.arrayObj.forEach(val => {
        if (this.state.alluser.length > 0) {
          if (JSON.stringify(this.state.alluser).indexOf(val.perId) === -1) {
            allList.push({ ...val });
          }
        } else {
          allList = JSON.parse(JSON.stringify(this.state.arrayObj));
        }
      });
    let number = 0; //显示的条数
    let totalUser = 0;
    // const userlist = this.state.alluser.map(val => {
    const userlist = allList.map(val => {
      const param = val;
      param.show = "none";
      if (this.state.currentDepartId === val.departId) {
        param.show = "block";
        totalUser = val.totalUser;
        number = number + 1;
        // this.setState({
        //   currentUserNumber:number+1
        // })
      }
      return param;
    });
    return (
      <div>
        <Checkbox.Group
          onChange={value => {
            this.setState({ checkboxValueArr: value });
            this.propsOnselect(value);
          }}
          value={this.state.checkboxValueArr}
        >
          {userlist.map(val => {
            // if (val.treeType === '2') {
            return (
              <Checkbox
                style={{ display: val.show === "block" ? val.show : "none" }}
                key={val.perId}
                className="radioStyle"
                value={val.perId}
              >
                <i className="usericon" />
                {val.name}
                {val.idCardNo ? "(" + val.idCardNo + ")" : ""}
              </Checkbox>
            );
            // }
            // return '';
          })}
        </Checkbox.Group>
        <div>
          <a
            style={{
              textAlign: "center",
              color: "#0f71ff",
              display:
                this.state.alluser.length > 0
                  ? number < totalUser
                    ? "block"
                    : "none"
                  : "none"
            }}
            onClick={() => {
              this.setState(
                {
                  formSearch: {
                    ...this.state.formSearch,
                    pageNumber: this.state.formSearch.pageNumber + 1
                  }
                },
                () => {
                  this.getDepartUser(this.state.currentDepartId, "seeMore");
                }
              );
            }}
          >
            点击加载更多...
          </a>
        </div>
      </div>
    );
  };

  render() {
    // const alluser = this.state.alluser.slice();
    // let number = 0;//显示的条数
    // const userlist = alluser.map(val => {
    //   if (this.state.currentDepartId === val.departId) {
    //     number = number + 1
    //   }
    // });

    const { navtree } = this.state;
    let listHeight = "285px"; //初始化list的高度
    if (this.refs.navPartment) {
      const navPartmentHeight = Number(
        getComputedStyle(this.refs.navPartment, null).height.replace(/px/g, "")
      );
      listHeight = 380 - 28 - 32 - navPartmentHeight;
    }
    return (
      <div className="SelectUser">
        <Search
          placeholder="搜索姓名/手机号/身份证"
          value={this.state.searchvalue}
          onChange={e => {
            this.setState(
              {
                searchvalue: e.target.value,
                // navtree: navtree.slice(0, 1),
                currentTree: navtree[0].children,
                searchPageNumber: 1
              },
              () => {
                if (this.state.searchvalue.trim().length > 0) {
                  this._getPerListByKeyword();
                }
              }
            );
          }}
          onSearch={value => console.log(value)}
        />
        {/* 公司名 */}
        {!this.state.searchvalue && this.renderNavBar()}
        <div className="list" style={{ height: listHeight }}>
          {/* 展示部门 */}
          {this.state.searchvalue.trim().length === 0 &&
            this.renderDepartment()}
          {/* 人员--单选框 */}
          {this.state.type === "radio" &&
          this.state.searchvalue.trim().length === 0
            ? this.renderRadio()
            : ""}
          {/* 人员--复选框（暂时不做复选框） */}
          {this.state.type === "checkbox" &&
          this.state.searchvalue.trim().length === 0
            ? this.renderChecked()
            : ""}
          {/* 搜索结果 */}
          {this.state.searchvalue.trim().length > 0 &&
          this.state.type === "radio"
            ? this.rendeSearchRadio()
            : ""}
          {this.state.searchvalue.trim().length > 0 &&
          this.state.type === "checkbox"
            ? this.renderSearchChecked()
            : ""}
        </div>
      </div>
    );
  }
}

export default GetUser;
