import React, { Component } from 'react';
import { Button, Modal } from 'antd';
import "./IEBrowserPrompt.less";
import { domainConfig } from '../../../utils/config';
import { connect } from 'dva';
@connect(state => ({
    companyInfo: state.global.companyInfo
}))
export default class IEBrowserPrompt extends Component {
    constructor(props, context) {
        super(props, context);
        this.state = {
            // isIEBrowser: props.isIEBrowser,
        };
    }

    /**
  * 生命周期
  */
    componentDidMount() {
    }

    handleCancel = (e) => {
        this.props.cancel(false);
    }

    render() {
        return (
            <div>
                <Modal
                    title="温馨提示"
                    visible={this.props.isIEBrowser}
                    // onCancel={this.handleCancel}
                    closable={false}
                    width={800}
                    className="IEBrowserPrompt"
                    footer={null}
                >
                    <div>
                        <h1 className="tips-title">对不起，您当前的浏览器不支持！</h1>
                        <p className="tips-con">{domainConfig.getName(this.props.companyInfo.regProvince)}秉承：为企业提供安全、稳定、高效的平台服务宗旨，因<br />此为保证系统安全，推荐使用Chrome，360或火狐浏览器的最新版本进行访问。</p>
                        <div className="tips-down">
                            <p>
                                <span>推荐浏览器：</span>
                                <br />
                                <span>（点击图标可下载，Safari为苹果电脑自带，无需下载）</span>
                            </p>
                            <div>
                                <ul className="tips-down-con">
                                    <li>
                                        <a href="http://www.google.cn/intl/zh-CN/chrome/browser/desktop/index.html" target="_blank" rel="noopener noreferrer">
                                            <img
                                                src={require('../../../assets/images/chrome.png')}
                                                alt=""
                                            />
                                            <br />
                                            谷歌浏览器
                                        </a>
                                    </li>
                                    <li>
                                        <a href="http://se.360.cn/" target="_blank" rel="noopener noreferrer">
                                            <img
                                                src={require('../../../assets/images/360.png')}
                                                alt=""
                                            />
                                            <br />
                                            360安全浏览器
                                            <br />
                                            （极速模式）
                                        </a>
                                    </li>
                                    <li>
                                        <a href="http://www.firefox.com.cn/" target="_blank" rel="noopener noreferrer">
                                            <img
                                                src={require('../../../assets/images/firefox.png')}
                                                alt=""
                                            />
                                            <br />
                                            火狐浏览器
                                        </a>
                                    </li>
                                    <li>
                                        <img
                                            src={require('../../../assets/images/safari.png')}
                                            alt=""
                                            style={{ height: "80px" }}
                                        />
                                        <br />
                                        Safari
                                    </li>
                                </ul>
                            </div>
                        </div>
                        <div className="footer-btn">
                            <Button
                                onClick={this.handleCancel}
                            >
                                确定
                            </Button>
                        </div>
                    </div>
                </Modal>
            </div>
        );
    }
}

