#2021-01-31 离京填报
CREATE TABLE `enrolment_leave_beijing`
(
    `id`                    bigint(20)   NOT NULL AUTO_INCREMENT COMMENT '主键',
    `active`                bit(1)       NULL COMMENT '逻辑删除',
    `create_time`           datetime     NULL COMMENT '创建时间',
    `update_time`           datetime     NULL COMMENT '更新时间',
    `update_by`             varchar(200) NULL COMMENT '更新人',
    `area_code`              bigint(20)   NULL COMMENT '区域编码',
    `org_id`                bigint(20)   NULL COMMENT '监管机构id',
    `com_name`              varchar(255) NULL COMMENT '公司名称',
    `com_id`                bigint(20)   NULL COMMENT '公司id',
    `filler_name`           varchar(255) NULL COMMENT '填写人',
    `filler_phone`          varchar(255) NULL COMMENT '填写人电话',
    `leave_person_name`     varchar(255) NULL COMMENT '离京的保安员姓名',
    `leave_person_id_number` varchar(255) NULL COMMENT '离京的保安员身份证号',
    `leave_person_phone`    varchar(255) NULL COMMENT '离京的保安员手机号码',
    `leave_time`            datetime     NULL COMMENT '离京时间',
    `leave_destination`     varchar(255) NULL COMMENT '离开准备去往的目的地',
    `leave_return_time`     datetime     NULL COMMENT '预计归期',
    `leave_transportation`  varchar(255) NULL COMMENT '交通方式',
    `arrival_time`          datetime     NULL COMMENT '到达日期',
    PRIMARY KEY (`id`)
);



drop table if EXISTS com_temp_task;
CREATE TABLE `com_temp_task` (
  `comTempTaskId` bigint(20) NOT NULL COMMENT '临保任务ID',
  `active` bit(1) DEFAULT true COMMENT '是否逻辑删除',
  `userId` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` varchar(100) DEFAULT NULL COMMENT '修改人ID',
  `taskName` varchar(50) DEFAULT NULL COMMENT '任务名称',
  `taskType` varchar(8) DEFAULT NULL COMMENT '任务类型',
  `taskStationType` varchar(6) DEFAULT NULL COMMENT '驻勤点类型',
  `serviceObject` varchar(100) DEFAULT NULL COMMENT '服务对象',
  `serviceObjectType` varchar(6) DEFAULT NULL COMMENT '服务对象类型',
  `serviceObjectSySituation` varchar(6) DEFAULT NULL COMMENT '服务对象涉外情况',
  `securityImportantUnit` varchar(1) DEFAULT '0' COMMENT '是否治安保卫重点单位',
  `taskContent` varchar(1000) DEFAULT NULL COMMENT '任务内容',
  `area` varchar(6) DEFAULT NULL COMMENT '任务地区code',
  `areaName` varchar(100) DEFAULT NULL COMMENT '任务地区',
  `taskAddress` varchar(100) DEFAULT NULL COMMENT '任务地址',
  `addressLongitude` varchar(50) DEFAULT NULL COMMENT '任务地址经度',
  `addressLatitude` varchar(50) DEFAULT NULL COMMENT '任务地址纬度',
  `execRange` bigint(20) DEFAULT NULL COMMENT '执行范围（单位:米）',
  `taskStatus` varchar(6) DEFAULT NULL COMMENT '任务状态',
  `startDate` date DEFAULT NULL COMMENT '任务开始日期',
  `endDate` date DEFAULT NULL COMMENT '任务截止日期',
  `chargePerId` bigint(20) DEFAULT NULL COMMENT '任务负责人ID',
  `comContractId` bigint(20) DEFAULT NULL COMMENT '企业合同ID',
  `orgId` bigint(20) DEFAULT NULL COMMENT '监管机构id',
  `orgName` varchar(200) DEFAULT NULL COMMENT '监管机构名称',
  `areaCode` varchar(6) DEFAULT NULL COMMENT '监管机构区域code',
  `comId` bigint(20) NOT NULL COMMENT '企业ID',
  PRIMARY KEY (`comTempTaskId`),
  KEY `index_com_temp_task_comId` (`comId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='临保任务';

drop table if EXISTS com_temp_task_per;
CREATE TABLE `com_temp_task_per` (
  `comTempTaskPerId` bigint(20) NOT NULL COMMENT '临保任务人员ID',
  `active` bit(1) DEFAULT true COMMENT '是否逻辑删除',
  `userId` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` varchar(100) DEFAULT NULL COMMENT '修改人',
  `comId` bigint(20) NOT NULL COMMENT '人员所在企业ID',
  `startDate` date DEFAULT NULL COMMENT '开始日期',
  `endDate` date DEFAULT NULL COMMENT '结束日期',
  `comTempTaskId` bigint(20) NOT NULL COMMENT '临保任务ID',
  `perId` bigint(20) NOT NULL COMMENT '人员ID',
  PRIMARY KEY (`comTempTaskPerId`),
  KEY `index_com_temp_task_per_comId` (`comId`),
  KEY `index_com_temp_task_per_comTempTaskId` (`comTempTaskId`),
  KEY `index_com_temp_task_per_perId` (`perId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='临保任务人员';