
-- 外网
CREATE TABLE `filerecordout` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `filepath` varchar(200) DEFAULT NULL COMMENT '文件名称',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `filename` varchar(300) DEFAULT NULL COMMENT '文件名称',
  `synchtype` varchar(100) DEFAULT NULL COMMENT '文件类型',
  `recordsize` int(11) DEFAULT NULL COMMENT '记录数量',
  PRIMARY KEY (`id`),
  KEY `r_id` (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2466 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT COMMENT='文件同步记录（用于数据同步）'



CREATE TABLE `filerecordstatus` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `synchdate` varchar(200) DEFAULT NULL COMMENT '同步日期',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `synchtype` varchar(300) DEFAULT NULL COMMENT '文件类型',
  `synchstatus` varchar(100) DEFAULT NULL COMMENT '文件状态',
  PRIMARY KEY (`id`),
  KEY `r_id` (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1096 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT COMMENT='文件同步记录（用于数据同步）'



ALTER TABLE `filerecord`
  ADD COLUMN  `create_time` datetime DEFAULT NULL COMMENT '创建时间' AFTER `filepath`,
 ADD COLUMN  `update_time` datetime DEFAULT NULL COMMENT '更新时间' AFTER `create_time`,
 ADD COLUMN  `filename` varchar(300) DEFAULT NULL COMMENT '文件名称' AFTER `update_time`,
ADD COLUMN `synchtype` VARCHAR (200) DEFAULT NULL COMMENT '文件类型' AFTER `filename`,
ADD COLUMN `recordsize` INT (11) DEFAULT NULL COMMENT '记录数量' AFTER `synchtype`


update filerecord set synchtype  = substring_index(filename,'_',1);




-- 内网

ALTER TABLE `filerecord` 
  ADD COLUMN  `create_time` datetime DEFAULT NULL COMMENT '创建时间' AFTER `filepath`,
 ADD COLUMN  `update_time` datetime DEFAULT NULL COMMENT '更新时间' AFTER `create_time`,
 ADD COLUMN  `filename` varchar(300) DEFAULT NULL COMMENT '文件名称' AFTER `update_time`,
ADD COLUMN `synchtype` VARCHAR (200) DEFAULT NULL COMMENT '文件类型' AFTER `filename`,
ADD COLUMN `recordsize` INT (11) DEFAULT NULL COMMENT '记录数量' AFTER `synchtype`


update filerecord set synchtype  = substring_index(filename,'_',1);