﻿SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for app_about
-- ----------------------------
DROP TABLE IF EXISTS `app_about`;
CREATE TABLE `app_about` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `aboutName` varchar(30) DEFAULT NULL COMMENT '功能名称',
  `aboutIntroduc` varchar(50) DEFAULT NULL COMMENT '功能简介',
  `aboutContent` text COMMENT '功能详情',
  `orderSort` int(11) DEFAULT NULL COMMENT '排序',
  `active` bit(1) DEFAULT NULL COMMENT '是否可用',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `updateTime` datetime DEFAULT NULL COMMENT '更新时间',
  `updateBy` varchar(100) DEFAULT NULL COMMENT '更新人',
  `linkUrl` varchar(100) DEFAULT NULL COMMENT '链接地址',
  `type` varchar(3) DEFAULT NULL COMMENT '系统类型(1:其它,2:百保盾)',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

-- ----------------------------
-- Table structure for app_ad
-- ----------------------------
DROP TABLE IF EXISTS `app_ad`;
CREATE TABLE `app_ad` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `companyId` int(11) DEFAULT NULL COMMENT '公司ID',
  `adType` varchar(3) DEFAULT NULL COMMENT '广告类型',
  `adName` varchar(50) DEFAULT NULL COMMENT '广告名称',
  `imageurl` varchar(100) DEFAULT NULL COMMENT '图片地址',
  `linkurl` varchar(1024) DEFAULT NULL COMMENT '链接地址',
  `onlinedate` date DEFAULT NULL COMMENT '上线日期',
  `offlinedate` date DEFAULT NULL COMMENT '下线日期',
  `displayStatic` varchar(3) DEFAULT NULL COMMENT '显示状态',
  `active` bit(1) DEFAULT NULL COMMENT '是否可用',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `updateTime` datetime DEFAULT NULL COMMENT '更新时间',
  `updateBy` varchar(100) DEFAULT NULL COMMENT '更新人',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='APP广告信息';

-- ----------------------------
-- Table structure for app_notice
-- ----------------------------
DROP TABLE IF EXISTS `app_notice`;
CREATE TABLE `app_notice` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `noticeTypeID` int(11) DEFAULT NULL COMMENT '通知分类ID',
  `person_id` int(11) DEFAULT NULL COMMENT '保安人员ID',
  `noticeTitle` varchar(50) DEFAULT NULL COMMENT '通知标题',
  `noticeContent` text COMMENT '通知内容',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `linkurl` varchar(100) DEFAULT NULL COMMENT '链接地址',
  `readStatus` varchar(3) DEFAULT NULL COMMENT '阅读情况(0:未读，1：已读)',
  `taskID` int(11) DEFAULT NULL COMMENT '任务ID',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=509 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

-- ----------------------------
-- Table structure for app_notice_type
-- ----------------------------
DROP TABLE IF EXISTS `app_notice_type`;
CREATE TABLE `app_notice_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `typeName` varchar(50) DEFAULT NULL COMMENT '类别名称',
  `imageurl` varchar(200) DEFAULT NULL COMMENT '图标',
  `active` bit(1) DEFAULT NULL COMMENT '是否可用',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `updateTime` datetime DEFAULT NULL COMMENT '更新时间',
  `updateBy` varchar(100) DEFAULT NULL COMMENT '更新人',
  PRIMARY KEY (`id`),
  KEY `AK_Key_1` (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

-- ----------------------------
-- Table structure for app_othersystem
-- ----------------------------
DROP TABLE IF EXISTS `app_othersystem`;
CREATE TABLE `app_othersystem` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `sytemType` varchar(3) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '系统类别',
  `displayStatic` varchar(3) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '显示状态',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Table structure for app_service
-- ----------------------------
DROP TABLE IF EXISTS `app_service`;
CREATE TABLE `app_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `sname` varchar(50) DEFAULT NULL COMMENT '服务名称',
  `scode` varchar(30) DEFAULT NULL COMMENT '服务编码',
  `logo` varchar(100) DEFAULT NULL COMMENT '服务Logo',
  `appType` varchar(10) DEFAULT NULL COMMENT 'APP类型',
  `linkUrl` varchar(500) DEFAULT NULL COMMENT '跳转地址',
  `orderSort` int(11) DEFAULT NULL COMMENT '排序顺序',
  `displayStatic` varchar(3) DEFAULT NULL COMMENT '显示状态',
  `active` bit(1) DEFAULT NULL COMMENT '是否可用',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `updateTime` datetime DEFAULT NULL COMMENT '更新时间',
  `updateBy` varchar(100) DEFAULT NULL COMMENT '更新人',
  `categoryID` int(11) DEFAULT NULL COMMENT '类别ID',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COMMENT='APP服务窗';

-- ----------------------------
-- Table structure for app_service_category
-- ----------------------------
DROP TABLE IF EXISTS `app_service_category`;
CREATE TABLE `app_service_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `categoryName` varchar(50) DEFAULT NULL COMMENT '类别名称',
  `active` bit(1) DEFAULT NULL COMMENT '是否可用',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `updateTime` datetime DEFAULT NULL COMMENT '更新时间',
  `updateBy` varchar(100) DEFAULT NULL COMMENT '更新人',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='APP服务窗类别';

-- ----------------------------
-- Table structure for app_service_person
-- ----------------------------
DROP TABLE IF EXISTS `app_service_person`;
CREATE TABLE `app_service_person` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `categoryID` int(11) DEFAULT NULL COMMENT '类别ID',
  `sname` varchar(50) DEFAULT NULL COMMENT '服务名称',
  `scode` varchar(30) DEFAULT NULL COMMENT '服务编码',
  `logo` varchar(100) DEFAULT NULL COMMENT '服务Logo',
  `linkUrl` varchar(50) DEFAULT NULL COMMENT '跳转地址',
  `orderSort` int(11) DEFAULT NULL COMMENT '排序顺序',
  `displayStatic` varchar(3) DEFAULT NULL COMMENT '显示状态',
  `active` bit(1) DEFAULT NULL COMMENT '是否可用',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `updateTime` datetime DEFAULT NULL COMMENT '更新时间',
  `updateBy` varchar(100) DEFAULT NULL COMMENT '更新人',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

-- ----------------------------
-- Table structure for app_service_person_category
-- ----------------------------
DROP TABLE IF EXISTS `app_service_person_category`;
CREATE TABLE `app_service_person_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `categoryName` varchar(50) DEFAULT NULL COMMENT '类别名称',
  `imageUrl` varchar(200) DEFAULT NULL COMMENT '图片',
  `active` bit(1) DEFAULT NULL COMMENT '是否可用',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `updateTime` datetime DEFAULT NULL COMMENT '更新时间',
  `updateBy` varchar(100) DEFAULT NULL COMMENT '更新人',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

-- ----------------------------
-- Table structure for task_feedback_log
-- ----------------------------
DROP TABLE IF EXISTS `task_feedback_log`;
CREATE TABLE `task_feedback_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `task_feedback_id` int(11) DEFAULT NULL COMMENT '子任务id',
  `person_id` int(11) DEFAULT NULL COMMENT '保安id',
  `dutyState` varchar(3) DEFAULT NULL COMMENT '值班状态（1正常2离岗）',
  `leaveType` varchar(3) DEFAULT NULL COMMENT '离岗原因类别（1执行紧急任务2提前完成任务3请假4其他）',
  `leaveComment` varchar(200) DEFAULT NULL COMMENT '离岗原因',
  `comment` varchar(200) DEFAULT NULL COMMENT '反馈信息',
  `image` varchar(512) DEFAULT NULL COMMENT '反馈图片',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=60 DEFAULT CHARSET=utf8;
