package com.bcxin.ars.webservice.police.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.log.BjRestLogDao;
import com.bcxin.ars.dao.sb.BackgroundApprovalDao;
import com.bcxin.ars.dto.sb.BackgroundApprovalDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.PersonBaseInfo;
import com.bcxin.ars.model.SecurityPerson;
import com.bcxin.ars.model.log.BjRestLog;
import com.bcxin.ars.model.sb.BackgroundApproval;
import com.bcxin.ars.model.sb.Personcertificate;
import com.bcxin.ars.service.ConfigService;
import com.bcxin.ars.service.sys.SysareaService;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.redis.RedisUtil;
import com.bcxin.ars.webservice.impl.SNBackGroupCensorServiceImpl;
import com.bcxin.ars.webservice.police.SecurityInterfaceService;
import com.bcxin.ars.webservice.police.enums.ResultType;
import com.bcxin.ars.webservice.util.SubStringUtil;
import com.founderinternation.datacenter.datadownload.client.DataDownLoadFactory;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.net.URLDecoder;
import java.util.*;
import java.util.stream.Collectors;

import static com.bcxin.ars.webservice.police.enums.ResultType.*;

/**
 * @Auther linqinglin
 * @date 2021/7/1 21:57
 */
@Service("securityInterfaceService_450000")
public class GXSecurityInterfaceService implements SecurityInterfaceService {

    /***
     * 日志
     */
    private static Logger logger = LoggerFactory.getLogger(SNBackGroupCensorServiceImpl.class);
    @Autowired
    private BjRestLogDao bjRestLogDao;

    @Autowired
    private ConfigService configService;

    @Autowired
    private SysareaService sysareaService;

    @Autowired
    private BackgroundApprovalDao backgroundApprovalDao;

    private static final String url = "http://10.151.151.83:8080/dataexchangeserver/innetApiPayload";

    /**
     * 广西人口信息管理系统-常住人口信息查询服务
     *
     */
    public static final String GX_APINAME_CZ = "gxtqdsj_R-450000230000-00002892";

    /**
     * 刑侦信息专业应用系统-全国在逃人员信息表查询服务
     */
    public static final String GX_APINAME_ZT = "gxtqdsj_R-450000230000-00001622";


    /**
     * 广西南宁警综SENDER_ID
     */
    public static final String GX_SENDER_ID = "94934D2A-9B28-4A1B-9C0A-A20E767BF3E1";

    /**
     * 广西南宁区厅AUTHCODE
     */
    public static final String GX_AUTHCODE = "YzBkNzRiOWQtMWRiOC00MjkzLTlhYjUtNzdkMDBlNDVjOTZh";

    @Value("${ZAFLAG}")
    private String ZAFLAG;

    @Autowired
    private RedisUtil redisUtil;

    private String call(List<String> idnums,List<String> parafs){
        Map<String, Object> paramMap = new HashMap<>();
        Map<String, Object> params = new HashMap<>();

        params.put("areaCode", "450100000000");
        params.put("qqdwdm", "南宁市公安局");
        params.put("qqdwmc", "450100000000");
        params.put("qqr", "450100210000");
        params.put("qqrsfzh", "450100210000");
        params.put("messageSequence", UUID.randomUUID());
        params.put("condition", " CERT_NO in (" + SubStringUtil.getStr(idnums) + ") and PERSON_STAT_NAME='有效'");
        params.put("parafs", parafs);
        params.put("maxReturnNum", "200");

        paramMap.put("authCode", GX_AUTHCODE);
        paramMap.put("apiName", GX_APINAME_CZ);
        paramMap.put("params", JSON.toJSONString(params));

        logger.error("广西人口信息管理系统-常住人口信息请求参数：{}",JSON.toJSONString(paramMap));
        logger.error("广西人口信息管理系统-常住人口信息请求地址：{}",url);
        //获取结果
        String result = postWithJson(url, paramMap);
        logger.error("广西人口信息管理系统-常住人口信息返回结果：{}",result);
        return result;
    }

    /**
     * 保安员背景筛查
     * @param personList
     */
    @Override
    public void censorPerson(List<SecurityPerson> personList) {
        List<String> idnumList= personList.stream().map(SecurityPerson::getIdNumber).collect(Collectors.toList());
        Map<String,PersonBaseInfo> personMap = getPersonInfo(idnumList, ResultType.NAME);
        Map<String,PersonBaseInfo> wfMap = isKeyPersons(idnumList);
        Map<String,PersonBaseInfo> dtMap = isEscapedPerson(idnumList);

        for (SecurityPerson securityPerson : personList) {
            BackgroundApprovalDto dto = new BackgroundApprovalDto();
            //身份证号
            dto.setIdNumber(securityPerson.getIdNumber());
            //姓名
            dto.setRealName(securityPerson.getRealName());
            //主键
            dto.setBusinessid(securityPerson.getId());
            //问题人员
            dto.setBusinesstype(Constants.BAY_FZR);

            dto.setAuthState(securityPerson.getIdentityAuthState());

            securityPerson.setBackgroundApprovals(censor(dto,personMap.get(securityPerson.getIdNumber()),wfMap.get(securityPerson.getIdNumber()),dtMap.get(securityPerson.getIdNumber())));
        }
    }

    /**
     * 资格证报名背景筛查
     * @param personList
     */
    @Override
    public void censoRenrollQualification(List<Personcertificate> personList) {
        List<String> idnumList= personList.stream().map(Personcertificate::getCardnumber).collect(Collectors.toList());
        Map<String,PersonBaseInfo> personMap = getPersonInfo(idnumList, PERSON);
        Map<String,PersonBaseInfo> wfMap = isKeyPersons(idnumList);
        Map<String,PersonBaseInfo> dtMap = isEscapedPerson(idnumList);
        //
        for (Personcertificate personcertificate : personList) {
            BackgroundApprovalDto dto = new BackgroundApprovalDto();
            dto.setBusinessid(personcertificate.getId());
            dto.setBusinesstype(Constants.BAYZ);
            dto.setIdNumber(personcertificate.getCardnumber());
            dto.setRealName(personcertificate.getName());
            PersonBaseInfo personBaseInfo = personMap.get(personcertificate.getCardnumber());
            if (personBaseInfo != null && StringUtil.isNotEmpty(personBaseInfo.getAddress())) {
                personcertificate.setPopulationAddress(personBaseInfo.getAddress());
            }
            personcertificate.setBackgroundApprovals(censor(dto,personBaseInfo,wfMap.get(personcertificate.getCardnumber()),dtMap.get(personcertificate.getCardnumber())));

        }

    }

    @Override
    public void censorNewPerson(List<SecurityPerson> personList) {

    }

    @Override
    public void censorNewQualification(List<Personcertificate> personList) {

    }

    /****
     * 背景筛查
     * @param dto 业务信息
     */
    public List<BackgroundApproval> censor(BackgroundApprovalDto dto,PersonBaseInfo czPerson,PersonBaseInfo dtPerson,PersonBaseInfo wfPerson) {
        List<BackgroundApproval> list = new ArrayList<>();
        try {
            BackgroundApproval backgroundApproval = new BackgroundApproval();
            backgroundApproval.setActive(true);
            backgroundApproval.setCreateTime(new Date());
            backgroundApproval.setUpdateTime(new Date());
            backgroundApproval.setApprovaldate(new Date());
            backgroundApproval.setBusinesstype(dto.getBusinesstype());
            backgroundApproval.setBusinessid(dto.getBusinessid());

            BackgroundApproval cz_BackgroundApproval = backgroundApproval.clone();
            cz_BackgroundApproval.setLibraryType(Constants.LIBRARYTYPE_CZ);

            BackgroundApproval dt_BackgroundApproval = cz_BackgroundApproval.clone();
            dt_BackgroundApproval.setLibraryType(Constants.LIBRARYTYPE_DT);
            BackgroundApproval wf_BackgroundApproval = cz_BackgroundApproval.clone();
            dt_BackgroundApproval.setLibraryType(Constants.LIBRARYTYPE_WF);
            if(czPerson != null){
                if(StringUtil.isNotEmpty(czPerson.getName()) && dto.getRealName().equals(czPerson.getName())){
                    cz_BackgroundApproval.setApprovalreason("主项信息符合");
                    cz_BackgroundApproval.setApprovalstate(Constants.APPROVALSTATE_TG);
                    cz_BackgroundApproval.setRgapprovalstate(Constants.APPROVALSTATE_TG);
                }else{
                    //姓名信息不匹配
                    cz_BackgroundApproval.setApprovalreason(Constants.LIBRARYTYPE_CZ_FAIL_MESSAGE);
                    cz_BackgroundApproval.setApprovalstate(Constants.APPROVALSTATE_BTG);
                    cz_BackgroundApproval.setRgapprovalstate(Constants.APPROVALSTATE_BTG);
                }
            }else{
                cz_BackgroundApproval.setApprovalreason(Constants.LIBRARYTYPE_CZ_FAIL);
                cz_BackgroundApproval.setApprovalstate(Constants.APPROVALSTATE_BTG);
                cz_BackgroundApproval.setRgapprovalstate(Constants.APPROVALSTATE_BTG);
            }
            list.add(cz_BackgroundApproval);

            if(dtPerson != null){
                dt_BackgroundApproval.setApprovalreason("在逃人员");
                dt_BackgroundApproval.setApprovalstate(Constants.APPROVALSTATE_BTG);
                dt_BackgroundApproval.setRgapprovalstate(Constants.APPROVALSTATE_BTG);
            }else{
                dt_BackgroundApproval.setApprovalreason("无在逃记录");
                dt_BackgroundApproval.setApprovalstate(Constants.APPROVALSTATE_TG);
                dt_BackgroundApproval.setRgapprovalstate(Constants.APPROVALSTATE_TG);
            }
            list.add(dt_BackgroundApproval);
            if(wfPerson != null){
                wf_BackgroundApproval.setApprovalreason("有违法犯罪记录");
                wf_BackgroundApproval.setApprovalstate(Constants.APPROVALSTATE_BTG);
                wf_BackgroundApproval.setRgapprovalstate(Constants.APPROVALSTATE_BTG);
            }else{
                wf_BackgroundApproval.setApprovalreason("无违法犯罪记录");
                wf_BackgroundApproval.setApprovalstate(Constants.APPROVALSTATE_TG);
                wf_BackgroundApproval.setRgapprovalstate(Constants.APPROVALSTATE_TG);
            }
            list.add(wf_BackgroundApproval);
        }catch (Exception e){
            e.printStackTrace();
            logger.error(e.getMessage(),e);
        }
        //问题人员无须保存
        if(!Constants.BAY_FZR.equals(dto.getBusinesstype()) && list != null && list.size() > 0) {
            //如果有记录的话，删除以前记录信息
            backgroundApprovalDao.delete(dto);
            //批量保存
            backgroundApprovalDao.batchSave(list);
        }

        return list;
    }

    @Override
    public  Map<String,PersonBaseInfo> getPersonInfo(List<String> idnums, ResultType resultType) {
        Map<String,PersonBaseInfo> personList = new HashMap<>();
        String code = "";
        if(ZAFLAG!=null && ZAFLAG.equals(Constants.ZAFLAG_YES)) {
            //人口库调用会异常或超时，循环三次，三次还是异常或超时，则获取失败
            for(int i = 0; i< Constants.ZAFLAG_COUNT; i++) {
                List<String> parafs = new ArrayList<>();
                parafs.add("NAME");//姓名
                parafs.add("CERT_NO");//证号
                switch (resultType){
                    case NAME:
                        break;
                    case PHOTO:
                        parafs.add("PHOTO");//照片
                        break;
                    case PERSON:
                        parafs.add("DOMIC_ADDR_NAME");//户籍地址
                        break;
                    default:
                        parafs.add("PHOTO");//照片
                        parafs.add("DOMIC_ADDR_NAME");//户籍地址
                        break;
                }

                String requestResult = call(idnums,parafs);
                //增加日志
                BjRestLog log = new BjRestLog();
                log.setResttype(GX_APINAME_CZ);

                if(!resultType.equals(PHOTO) && !resultType.equals(ALL)) {
                    log.setResponseContext(requestResult);
                }
                log.setRequestContext(JSON.toJSONString(idnums));
                //创建时间
                log.setCreateTime(new Date());
                //有效标记
                log.setActive(true);
                //更新时间
                log.setUpdateTime(new Date());
                //更新者
                log.setUpdateBy(Constants.APPROVAL_SYSTEM);
                bjRestLogDao.save(log);
                //如果不为空则没有数据
                if (requestResult != null && !requestResult.equals("")) {

                    JSONObject result = JSON.parseObject(requestResult);
                    if (Constants.NO.equals(result.get("code"))) {
                        result = JSON.parseObject(result.get("result").toString());
                        if (Constants.MINISTRY_CODE_SUCCES_SXNW.equals(result.get("status").toString())) {
                            if (result.get("data") != null) {
                                result = JSON.parseObject(result.get("data").toString());
                                String totalRows = result.get("totalRows").toString();
                                if (Long.parseLong(totalRows) > 0) {
                                    JSONArray results = JSONArray.parseArray(result.get("results").toString());

                                    PersonBaseInfo person = null;

                                    for (Object o : results) {
                                        result = (JSONObject)o;

                                        person = new PersonBaseInfo();
                                        if(result.get("NAME") != null) {
                                            person.setName(result.get("NAME").toString());
                                        }
                                        if(result.get("CERT_NO") != null) {
                                            person.setIdnum(result.get("CERT_NO").toString());
                                        }
                                        if(result.get("DOMIC_ADDR_NAME") != null) {
                                            person.setAddress(result.get("DOMIC_ADDR_NAME").toString());
                                        }
                                        if(result.get("PHOTO") != null) {
                                            person.setPhoto(result.get("PHOTO").toString());
                                        }
                                        personList.put(person.getIdnum(),person);
                                    }

                                }
                            }
                        }
                    }
                }
                //如果执行成功则返回
                if(Constants.ZAFLAG_CODE_SUCCESS.equals(code)){
                    break;
                }
            }
        }else{
            code = Constants.ZAFLAG_CODE_SUCCESS;
        }
        //如果执行成功则返回
        if(!Constants.ZAFLAG_CODE_SUCCESS.equals(code)){
            throw new ArsException("陕西人口库调用异常！");
        }

        return personList;
    }

    @Override
    public Map<String, PersonBaseInfo> getNewPersonInfo(List<String> idnums) {
        return null;
    }

    /**
     * 广西【警综-重点人员】
     * 是否重点人员
     * @param idnums
     */
    private Map<String,PersonBaseInfo> isKeyPerson(List<String> idnums){
        Map<String,PersonBaseInfo> personList = new HashMap<>();
        try {
            DataDownLoadFactory dataDownLoadFactory = DataDownLoadFactory.getInstance();
            if(dataDownLoadFactory == null){
                logger.error("DataDownLoadFactory异常");
            }
            //此方法新建一个实例 相当于new
            String ip = "10.236.17.18";
            String port = "8212";
            String methodName = "QueryJzZdry";
            String tableCode = "010112";
            String senderId = GX_SENDER_ID;
            String condition = " SFZH in (" + SubStringUtil.getStr(idnums) + ") and YXX = '1' ";
            String[] fileds = {"XM","ZDRYLBBJ"};
            //String[] fileds = {"*"};
            int totalCount = 1;// 0=< 默认返回所有符合条件的数据，>0 符合条件的totalCount条
            int waittime = 0;//大于等于0为等待wait ms ，等于 0 为不等待
            String result = dataDownLoadFactory.getFromRemote(ip, port, methodName, tableCode, senderId, condition, fileds, totalCount, waittime);
            logger.error("广西【警综-重点人员】返回结果：{}",result);
            long start = System.currentTimeMillis();
            int sum = 0;
            boolean isHadData = false;
            if ("success".equals(result)) {
                if (dataDownLoadFactory.getResultQueue() != null || !dataDownLoadFactory.isClose()) {
                    //当返回队列不为空或者链接未关闭继续等待接收数据
                    while (!dataDownLoadFactory.getResultQueue().isEmpty() || !dataDownLoadFactory.isClose()) {
                        Object[] resultstr = dataDownLoadFactory.getResultQueue().poll();
                        //获取返回数据为 Object[2]  rsultstr[0] 为一个map key:value  分别是字段名和字段类型编码（对应类型下面会有介绍）；
                        //map为linkedHashMap 获取keyset为字段set；
                        //resultstr[1] 为List<Object[]> 返回数据包，
                        //object[]对应一个row每个object对应一列，和上面keyset 字段对应
                        if (resultstr == null) {
                            //休息1秒
                            Thread.sleep(1);
                        } else {//获取到数据 TO DO数据处理
                            isHadData = true;
                            sum++;
                            System.out.println("sum:" + sum * 10000);
                            if (resultstr.length == 2 && resultstr[0] != null && resultstr[1] != null) {
                                List<Object[]> resultList = (List<Object[]>) resultstr[1];
                            }
                        }
                    }
                    logger.error("数据结果队列：" + isHadData);
                    long end = System.currentTimeMillis();
                    logger.error("耗时：" + (double) (end - start) / 1000 + " 秒");
                    dataDownLoadFactory.closeSession();
                    logger.error("耗时：" + (double) (System.currentTimeMillis() - start) / 1000 + " 秒");
                }
            }
            //return isHadData;
        }catch (Exception e){
            e.printStackTrace();
            logger.error(e.getMessage(), e);
            throw new ArsException("广西【警综-重点人员】调用异常！！");
        }
        return personList;
    }
    private Map<String,PersonBaseInfo> isKeyPersons(List<String> idnums){
        Map<String,PersonBaseInfo> personList = new HashMap<>();

        PersonBaseInfo person = null;
        for (String idnum : idnums) {
            if(isKeyPerson(idnum)){
                person = new PersonBaseInfo();
                person.setIdnum(idnum);
            }
        }
        return personList;
    }

    /**
     * 广西【警综-重点人员】
     * 是否重点人员
     * @param idnum
     */
    private boolean isKeyPerson(String idnum){
        try {
            DataDownLoadFactory dataDownLoadFactory = DataDownLoadFactory.getInstance();
            if(dataDownLoadFactory == null){
                logger.error("DataDownLoadFactory异常");
            }
            //此方法新建一个实例 相当于new
            String ip = "10.236.17.18";
            String port = "8212";
            String methodName = "QueryJzZdry";
            String tableCode = "010112";
            String senderId = GX_SENDER_ID;
            String condition = " SFZH ='"+idnum+"' and YXX = '1' ";
            String[] fileds = {"XM","ZDRYLBBJ"};
            //String[] fileds = {"*"};
            int totalCount = 1;// 0=< 默认返回所有符合条件的数据，>0 符合条件的totalCount条
            int waittime = 0;//大于等于0为等待wait ms ，等于 0 为不等待
            String result = dataDownLoadFactory.getFromRemote(ip, port, methodName, tableCode, senderId, condition, fileds, totalCount, waittime);
            logger.error("广西【警综-重点人员】返回结果：{}",result);
            long start = System.currentTimeMillis();
            int sum = 0;
            boolean isHadData = false;
            if ("success".equals(result)) {
                if (dataDownLoadFactory.getResultQueue() != null || !dataDownLoadFactory.isClose()) {
                    //当返回队列不为空或者链接未关闭继续等待接收数据
                    while (!dataDownLoadFactory.getResultQueue().isEmpty() || !dataDownLoadFactory.isClose()) {
                        Object[] resultstr = dataDownLoadFactory.getResultQueue().poll();
                        //获取返回数据为 Object[2]  rsultstr[0] 为一个map key:value  分别是字段名和字段类型编码（对应类型下面会有介绍）；
                        //map为linkedHashMap 获取keyset为字段set；
                        //resultstr[1] 为List<Object[]> 返回数据包，
                        //object[]对应一个row每个object对应一列，和上面keyset 字段对应
                        if (resultstr == null) {
                            //休息1秒
                            Thread.sleep(1);
                        } else {//获取到数据 TO DO数据处理
                            isHadData = true;
                            sum++;
                            logger.error("广西【警综-重点人员】返回结果：{}",JSON.toJSONString(resultstr));
                            if (resultstr.length == 2 && resultstr[0] != null && resultstr[1] != null) {
                                List<Object[]> resultList = (List<Object[]>) resultstr[1];
                            }
                        }
                    }
                    logger.error("数据结果队列：" + isHadData);
                    long end = System.currentTimeMillis();
                    logger.error("耗时：" + (double) (end - start) / 1000 + " 秒");
                    dataDownLoadFactory.closeSession();
                    logger.error("耗时：" + (double) (System.currentTimeMillis() - start) / 1000 + " 秒");
                }
            }
            return isHadData;
        }catch (Exception e){
            e.printStackTrace();
            logger.error(e.getMessage(), e);
            throw new ArsException("广西【警综-重点人员】调用异常！！");
        }
    }

    /**
     * 刑侦信息专业应用系统-全国在逃人员信息表查询服务	gxtqdsj_R-450000230000-00001622
     * 是否在逃人员
     * @param idnums
     */
    private Map<String,PersonBaseInfo> isEscapedPerson(List<String> idnums){
        Map<String,PersonBaseInfo> personList = new HashMap<>();
        try {
            Map<String, Object> paramMap = new HashMap<>();
            Map<String, Object> params = new HashMap<>();


            List<String> parafs = new ArrayList<>();
            parafs.add("NAME");//姓名
            parafs.add("CERT_NO");//身份证
            parafs.add("UNDO_ORGA_PSAG_CODE");//撤销单位代码
            parafs.add("UNDO_JUDGE_FLAG");//撤销判断标识

            params.put("areaCode", "450100000000");
            params.put("qqdwdm", "南宁市公安局");
            params.put("qqdwmc", "450100000000");
            params.put("qqr", "450100210000");
            params.put("qqrsfzh", "450100210000");
            params.put("messageSequence", UUID.randomUUID());
            //params.put("condition", " CERT_NO in (" + SubStringUtil.getStr(idnums) + ") and (UNDO_ORGA_PSAG_CODE !='')");
            params.put("condition", " CERT_NO in (" + SubStringUtil.getStr(idnums) + ")");
            params.put("parafs", parafs);
            params.put("maxReturnNum", "20");

            //NAME,PHOTO,DOMIC_ADDR_NAME,CERT_NO

            paramMap.put("authCode", GX_AUTHCODE);
            paramMap.put("apiName", GX_APINAME_ZT);
            paramMap.put("params", JSON.toJSONString(params));

            logger.error("刑侦信息专业应用系统-全国在逃人员信息表请求参数：{}",JSON.toJSONString(paramMap));
            logger.error("刑侦信息专业应用系统-全国在逃人员信息表请求地址：{}",url);
            //获取结果
            String resultStr = postWithJson(url, paramMap);
            logger.error("刑侦信息专业应用系统-全国在逃人员信息表返回结果：{}",resultStr);

            //增加日志
            BjRestLog log = new BjRestLog();
            log.setResttype(GX_APINAME_ZT);
            log.setResponseContext(resultStr);
            log.setRequestContext(JSON.toJSONString(idnums));
            //创建时间
            log.setCreateTime(new Date());
            //有效标记
            log.setActive(true);
            //更新时间
            log.setUpdateTime(new Date());
            //更新者
            log.setUpdateBy(Constants.APPROVAL_SYSTEM);
            bjRestLogDao.save(log);
            if (StringUtil.isNotEmpty(resultStr)) {
                JSONObject result = JSON.parseObject(resultStr);
                if (Constants.NO.equals(result.get("code"))) {
                    result = JSON.parseObject(result.get("result").toString());
                    if (Constants.MINISTRY_CODE_SUCCES_SXNW.equals(result.get("status").toString())) {
                        if (result.get("data") != null) {
                            result = JSON.parseObject(result.get("data").toString());
                            String totalRows = result.get("totalRows").toString();
                            if (Long.parseLong(totalRows) > 0) {
                                JSONArray results = JSONArray.parseArray(result.get("results").toString());
                                PersonBaseInfo person = null;
                                for (Object o : results) {
                                    result = (JSONObject)o;

                                    person = new PersonBaseInfo();
                                    if(result.get("NAME") != null) {
                                        person.setName(result.get("NAME").toString());
                                    }
                                    if(result.get("CERT_NO") != null) {
                                        person.setIdnum(result.get("CERT_NO").toString());
                                    }
                                    personList.put(person.getIdnum(),person);
                                }
                            }
                        }
                    }
                }
            }
        }catch (Exception e){
            e.printStackTrace();
            logger.error(e.getMessage(), e);
            throw new ArsException("刑侦信息专业应用系统-全国在逃人员信息调用异常！！");
        }

        return personList;
    }


    private String postWithJson(String requestUrl, Map<String, Object> paramMap){
        String returnValue = StringUtil.EMPTY;
        CloseableHttpClient httpClient = HttpClients.createDefault();
        ResponseHandler<String> responseHandler = new BasicResponseHandler();
        try{
            //第一步：创建HttpClient对象
            httpClient = HttpClients.createDefault();
            //第二步：创建httpPost对象
            HttpPost httpPost = new HttpPost(requestUrl);
            RequestConfig.Builder requestConfig = RequestConfig.custom();
            requestConfig.setConnectTimeout(30000);
            requestConfig.setConnectionRequestTimeout(30000);
            requestConfig.setSocketTimeout(30000);
            //第三步：给httpPost设置JSON格式的参数
            StringEntity requestEntity = new StringEntity(JSON.toJSONString(paramMap),"utf-8");
            requestEntity.setContentEncoding("UTF-8");
            httpPost.setHeader("Content-type", "application/json");
            httpPost.setEntity(requestEntity);
            httpPost.setConfig(requestConfig.build());

            //第四步：发送HttpPost请求，获取返回值
            returnValue = httpClient.execute(httpPost,responseHandler); //调接口获取返回值时，必须用此方法
        }catch(Exception e){
            e.printStackTrace();
            logger.error(e.getMessage());
            throw new ArsException(requestUrl+"：接口调用异常！");
        }finally {
            try {
                httpClient.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        //第五步：处理返回值
        return returnValue;
    }

    public static void main(String[] args) {
        List<String> idnums = new ArrayList();

        idnums.add("1");
        idnums.add("1");
        idnums.add("1");
        idnums.add("1");
        StringBuilder idnumStr = new StringBuilder();
        for (String idnum : idnums) {
            idnumStr.append(idnum+",");
        }
        idnumStr.substring(0,idnumStr.lastIndexOf(","));

        System.out.println(idnumStr.substring(0,idnumStr.lastIndexOf(",")));

        System.out.println(URLDecoder.decode("\\u6ca1\\u6709\\u67e5\\u8be2\\u5230\\u76f8\\u5173\\u4fe1\\u606f"));
    }

}
