package com.bcxin.ars.webservice.dto;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * 北京核查库返回结果
 * 格式
 * {
 * "uuid":"",
 * "msg":"ok",
 * "status":0,
 * "results":[{
 * "value":"违法犯罪(其他)",
 * "disposalWay":"",
 * "color":"yellow",
 * "resourceName":"违法犯罪",
 * "order":"2",
 * "key":"criminalType"
 * }]
 * }
 *
 * @author zhangyutong
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ProblemResult {

    private String uuid;
    private String msg;
    private Integer status;
    private List<Object> results;
}
