package com.bcxin.ars.webservice;

import com.bcxin.ars.dto.sb.BackgroundApprovalDto;
import com.bcxin.ars.model.PersonBaseInfo;
import com.bcxin.ars.model.SecurityPerson;
import com.bcxin.ars.model.sb.BackgroundApproval;

import java.util.List;

/**
 * 人口库 背景审查
 * @author linqinglin
 * @date 2019/04/17 0017 17:00
 */
public interface BackGroupCensorService {

    String getPhoto(String idNumber, String name);
    /**
     * 调人口库获取人口库信息
     * 不同省份不同实现
     * @param idNumber 身份证号
     * @return
     */
    PersonBaseInfo getPopulationInfo(String idNumber,boolean needPhoto);

    /****
     * 背景筛查
     * @param dto 业务信息
     */
    List<BackgroundApproval> censor(BackgroundApprovalDto dto);

    /****
     * 查询背景筛查结果
     * @param dto 业务信息
     */
    List<BackgroundApproval> getCensorResult(BackgroundApprovalDto dto);

    /****
     * 背景筛查
     * 不同省份不同实现
     * @param dto 业务信息
     */
    List<BackgroundApproval> censorFromBase(BackgroundApprovalDto dto,boolean needCZ);

    /****
     * 查询背景筛查结果
     * @param idNumber 身份证号
     * @param name 姓名
     */
    String getCensorResult(String idNumber, String name);

    /***
     * 保安人员员背景筛查保存到问题人员表
     * @param person 人员
     * @param backgroundApprovals 结果列表
     * @return 背景筛查结果
     */
    void censorSaveProblemPerson(SecurityPerson person, List<BackgroundApproval> backgroundApprovals);
    /***
     * 保安人员员背景筛查保存到问题人员表
     * @param person 人员
     * @param backgroundApprovals 结果列表
     * @return 背景筛查结果
     */
    void censorSaveProblemPersonCriminal(SecurityPerson person, List<BackgroundApproval> backgroundApprovals);
    /***
     * 背景筛查不通过人员重新比对
     * @param person 人员
     * @param backgroundApprovals 结果列表
     * @return 背景筛查结果
     */
    void censorSaveProblemPersonNoPassCensorStatus(SecurityPerson person, List<BackgroundApproval> backgroundApprovals);

    /****
     * 背景筛查 返回 筛查结果（003通过  004不通过 ）
     * @param dto 业务信息
     */
    String getCensorStatus(BackgroundApprovalDto dto);

}
