package com.bcxin.ars.service.task;

import java.util.List;
import java.util.Map;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.ReportData;
import com.bcxin.ars.dto.TaskFeedbackSearchDto;
import com.bcxin.ars.dto.task.FeedBackDetailDto;
import com.bcxin.ars.dto.task.TaskDetailSearchDto;
import com.bcxin.ars.dto.task.TaskDto;
import com.bcxin.ars.dto.task.TaskFeedBackDto;
import com.bcxin.ars.dto.task.TaskListDto;
import com.bcxin.ars.model.task.TaskFeedback;

/**
 * 任务反馈服务类
 * @author Ethan
 */
public interface TaskFeedbackService {


	/**
	 * 获取指定任务下指定反馈列表
	 * @param taskId
	 * @return
	 */
	TaskFeedback findById(Long id);

	/**
	 * 获取指定任务下指定反馈列表
	 * @param taskId
	 * @return
	 */
	TaskFeedback findByIdRand();
	/**
	 * 获取指定任务下指定反馈列表
	 * @param taskId
	 * @return
	 */
	List<TaskFeedback> findByTaskId(Long taskId);

	/**
	 * 获取指定任务下指定反馈列表(部分字段）
	 * @param taskId
	 * @return
	 */
	List<TaskFeedback> findFeedbackByTaskid(Long taskId,long personid);
	List<TaskFeedback> findUrgentFeedbackByTaskid(Long taskId,long personid);
	List<TaskFeedback> findAllFeedbackByTaskid(Long taskId,long personid);

	/**
	 * 获取下一班次子任务
	 * @param taskId
	 * @return
	 */
	List<TaskFeedback> findFeedbackNext(Long taskId);
	
	/**
	 * 根据保安员获取其未反馈的任务
	 * @param personId
	 * @return
	 */
	List<TaskFeedback> findNotFeedback(Long personId);

	/**
	 * 更新任务反馈
	 * @param feedback
	 */
	TaskFeedback saveOrUpdate(TaskFeedback feedback);
	
	/**
	 * 任务历史搜索
	 * @param dto
	 * @return
	 */
	TaskFeedbackSearchDto search(TaskFeedbackSearchDto dto);
	
	/**
	 * 任务地区画像
	 * @return
	 */
	List<ReportData> findAreaReport();

	/**
	 * 任务类型画像
	 * @return
	 */
	Map<String, String[]> findCatalogReport();

	/**
	 * 任务人员等级画像
	 * @return
	 */
	List<ReportData> findLevelReport();

	/**
	 * 
	 * <b>Function </b> 根据用户ID,任务状态，分钟数查询
	 * 
	 * @param personId
	 * @param taskStatus
	 * @param minutes
	 * @return
	 * @author LinQingLin 
	 * @date 2017年3月9日 下午5:55:07
	 * @注意事项 </b>
	 * <b>
	 */
	List<TaskFeedback> findFeedbackList(Long personId, Long taskStatus, Integer minutes);


	/***
	 * 根据任务ID、人员ID、日期查询反馈信息表
	 * @param taskId 任务ID
	 * @param personId 人员ID
	 * @param date 日期
	 * @return
	 */
	TaskFeedback findByTaskIdAndPerson(Long taskId, Long personId);
	
	List<TaskFeedback> searchForDataSynchronization( DataSynchronizationSearchDto searchDto);
	

	
	void saveOrUpdateForDS(TaskFeedback feedback);
	


	List<TaskFeedBackDto> findTaskFeedbasksByTask(TaskDetailSearchDto taskDetailDto, TaskDto taskDto);

	/**
	 * 查询大于当前时间的下一班次，精确到秒
	 * @param taskListDto
	 * @return
	 */
	TaskFeedBackDto findNextFeedBack_back(TaskListDto taskListDto);

	/**
	 * 根据子任务ID获取子任务详情信息
	 * @param id
	 * @return
	 */
	FeedBackDetailDto findFeedBackDetailById(Long id);
	/**
	 * 根据保安ID获取可签到子任务列表信息
	 * @param id
	 * @return
	 */
	List<FeedBackDetailDto> findBackDetailByPersonid(Long personId);
	
	/**V1.0.9
	 * 任务签到
	 * @param feedback
	 */
	TaskFeedback saveAppSign(TaskFeedback feedback);
	
	/**
	 * V1.0.9
	 * 计算已完成班次总时长
	 * @param taskId
	 * @param personId
	 * @return
	 */
	Long findFeedBackFinishSumTime(Long taskId, Long personId);
	
	/**
	 * V1.0.9
	 * 根据任务ID,保安人员ID，班次状态查询班次列表
	 * @param taskId
	 * @param personId
	 * @param scheduleStatus
	 * @return
	 */
	List<TaskFeedBackDto> findFeedBasksByScheduleStatus(TaskDetailSearchDto taskDetailDto);
	/**
	 * V1.0.9
	 * 返回子任务列表
	 * @param taskDetailDto
	 * @param taskDto
	 * @return
	 */
	List<TaskFeedBackDto> findTaskFeedbasksByTask_V109(TaskDetailSearchDto taskDetailDto);
	
	/**
	 * V1.0.9
	 * 获取指定任务下指定反馈列表(部分字段）
	 * @param taskId
	 * @param personid
	 * @return
	 */
	List<TaskFeedback> findFeedbackByTaskid_V109(Long taskId,long personid);
}
