/*
 * Copyright (c) 2015 xuerdongcom@126.com All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 */
package com.bcxin.ars.service.sys;

import com.bcxin.ars.dto.LayTree;
import com.bcxin.ars.dto.Tree;
import com.bcxin.ars.dto.TreeView;
import com.bcxin.ars.dto.sys.SysareaSearchDTO;
import com.bcxin.ars.model.sys.Sysarea;

import java.util.List;

/**
 * @author xuerdong
 * @since 1.1
 */
public interface SysareaService {

	List<TreeView> searchForTreeView(SysareaSearchDTO sysareaSearchDTO);

	/**
	 * 查询
	 * @param sysareaSearchDTO
	 * @return
	 */
	SysareaSearchDTO search(SysareaSearchDTO sysareaSearchDTO);

	public SysareaSearchDTO searchAll(SysareaSearchDTO sysareaSearchDTO);

	List<TreeView> searchForCompany(SysareaSearchDTO sysareaSearchDTO);

	List<Sysarea> findByParentId(Long parentid);

	Sysarea findByCode(String code);
	
	List<TreeView> findTreeViewByCode(String areacode);

	List<Sysarea> findCurrentAreaList(SysareaSearchDTO sysareaSearchDTO);
	/***
	 * 根据编码获取全称
	 * @param code
	 * @return
	 */
	String  findByCodeForFullName(String code);

    List<TreeView> searchSimpleTreeView(SysareaSearchDTO sysareaSearchDTO);
    
	List<Sysarea> findCurrentSystemAreaList();

	List<Tree> searchForTree(SysareaSearchDTO dto);

    List<LayTree> searchForLayTree(SysareaSearchDTO searchDto);
}
