package com.bcxin.ars.service.sys;

import com.bcxin.ars.dto.LayTree;
import com.bcxin.ars.dto.MenuTree;
import com.bcxin.ars.dto.page.ModuleMenuPageSearchDto;
import com.bcxin.ars.dto.sys.MenuDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sys.ModuleMenu;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

import java.util.List;

/**
 * 功能权限表Service接口
 *
 * @author linqinglin
 * @Date 2020-03-27 14:35:21
 */
public interface ModuleMenuService {


    /****
     * 保存
     * @param moduleMenu
     * @return
     */
    int save(ModuleMenu moduleMenu);

    /****
     * 主键查询
     * @param id
     * @return
     */
    ModuleMenu findById(Long id);

    /**
     * 分页查询
     * @param searchDto
     * @param page
     * @return
     */
    void searchForPage(ModuleMenuPageSearchDto searchDto, AjaxPageResponse<ModuleMenu> page);

    List<ModuleMenu> searchForTree(ModuleMenuPageSearchDto dto, AjaxPageResponse<ModuleMenu> page);

    List<ModuleMenu> findForMenu();

    List<ModuleMenu> setMenuTree(List<ModuleMenu> menuList);

    void delete(ModuleMenu moduleMenu);

    void updateSeq(ModuleMenu moduleMenu);

    void enable(ModuleMenu moduleMenu);

    List<MenuTree> findMenuTreeForPermission(Long roleId);

    List<LayTree> findForLayTree();

    List<ModuleMenu> findForPermission(User user);

    void useOld(ModuleMenu moduleMenu);

    ModuleMenu findByUniqueId(String uniqueId);

    List<MenuDto> searchForGXTree();
}
