package com.bcxin.ars.service.sys;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.enums.MinisterialDataType;
import com.bcxin.ars.model.sys.MinisterialLog;

import java.util.List;
import java.util.Map;


/**
 * 数据上报部级接口记录Service接口
 * 
 * @author linqinglin
 * @date 2021-03-04
 */
public interface MinisterialLogService{
    /****
     * 删除
     * @param ministerialLog
     * @return
     */
    int delete(MinisterialLog ministerialLog);

    /****
     * 保存
     * @param ministerialLog
     * @return
     */
    int save(MinisterialLog ministerialLog);

    /****
     * 选择性修改
     * @param ministerialLog
     * @return
     */
    void updateSelective(MinisterialLog ministerialLog);

    /****
     * 主键查询
     * @param id
     * @return
     */
    MinisterialLog findById(Long id);

    /**
     * 外导内查询
     * @param searchDto
     * @return
     */
    List<MinisterialLog> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    /**
     * 内导外查询
     * @param startDate
     * @return
     */
    List<MinisterialLog> findDSOutList(String startDate);

    /**
     * 批量保存
     * @param list
     */
    void importBatch(List<MinisterialLog> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<MinisterialLog> findByBatchId(List<MinisterialLog> list);


    /**
     * 查询
     * @param ministerialLog
     */
    MinisterialLog find(MinisterialLog ministerialLog);

    /**
     * 反射查询数据
     * @param dataType
     * @return
     */
    List<Map> getBusinessDatas(MinisterialDataType dataType,int limit);

    /**
     * 反射查询数据 带查询条件
     * @param dataType
     * @param paramMap
     * @return
     */
    List<Map> getBusinessDatasByParam(MinisterialDataType dataType,Map paramMap);

    void saveByType(MinisterialLog ministerialLog, List subList);
}
