package com.bcxin.ars.service.sys;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.sys.DataChange;

import java.util.List;

/**
 * 数据变更记录表Service接口
 *
 * @author linqinglin
 * @Date 2020-05-09 14:18:13
 */
public interface DataChangeService {

   /****
     * 删除
     * @param dataChange
     * @return
     */
    int delete(DataChange dataChange);

    /****
     * 保存
     * @param dataChange
     * @return
     */
    int save(DataChange dataChange);

    /****
     * 选择性修改
     * @param dataChange
     * @return
     */
    void updateSelective(DataChange dataChange);

    /****
     * 主键查询
     * @param id
     * @return
     */
    DataChange findById(Long id);

    /**
     * 外导内查询
     * @param searchDto
     * @return
     */
    List<DataChange> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    /**
     * 内导外查询
     * @param startDate
     * @return
     */
    List<DataChange> findDSOutList(String startDate);

    /**
     * 批量保存
     * @param list
     */
    void importBatch(List<DataChange> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<DataChange> findByBatchId(List<DataChange> list);
}
