package com.bcxin.ars.service.sys;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.ApprovalDTO;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.page.ApprovalOutTimePageSearchDto;
import com.bcxin.ars.dto.page.ApprovalPageSearchDto;
import com.bcxin.ars.dto.sys.ApprovalFormDto;
import com.bcxin.ars.model.PageResult;
import com.bcxin.ars.model.sb.Legalchange;
import com.bcxin.ars.model.sys.Approval;
import com.bcxin.ars.model.task.ComContract;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

import java.io.File;
import java.util.List;
import java.util.Map;

/**
 * Created by 苏 on 2017/5/1.
 */
public interface ApprovalService {


    /**
     * 保全审批分页查询
     */
    PageResult queryApprovalList(Map<Object, Object> p);

    int queryAllCnt(Map<Object, Object> p);

     int queryWeekNewAddCnt(Map<Object, Object> p);

    int queryMonthsNewAddCnt(Map<Object, Object> p);

     int queryYearNewAddCnt(Map<Object, Object> p);
    void saveBatchArrovalForImport(List<Approval> approvalList);
    /**
     *
     * @Decription:批量插入审批表
     * @author：zhongjianhui
     * @method  batchImportApproval
     * @date：2018/8/15 15:27
     * @params： * @param approval
     * @param pathMap
     * @return void
     */
    void batchImportApproval(List<Approval> approvalList, Map<String, String> pathMap);


    /***
     * 根据用户ID查询用户和业务类型的权限
     * @param userId
     * @return
     */
     List findAllUserBusinessType(Long userId);

    /**
     * 查询待办事项
     * @param dto 数据传输对象
     * @return
     */
    ApprovalDTO query(ApprovalDTO dto);
    /**
     * 查询待办事项
     * @param dto 数据传输对象
     * @return
     */
    ApprovalDTO queryTB(ApprovalDTO dto);

    /***
     * 保存审批信息
     * @param dto
     */
    void saveApprovalForZZ(ApprovalDTO dto);

     void createCard(Approval approval, String isNeedActiviy);

    /***
     * 报名确认
     * @param dto
     */
    void saveApprovalForManual(ApprovalDTO dto,String context);

    /***
     * 保存批复
     * 信息
     * @param dto
     */
    void saveReply(ApprovalDTO dto);
    /***
     * 保存批复
     * 信息
     * @param dto
     */
    void saveBQ(ApprovalDTO dto);
    /**
     * 根据ID获取审批信息
     * @param id
     * @return
     */
    ApprovalDTO queryById(Long id);
    /***
     * 根据业务类型和业务ID获取审批信息表
     * @param dto
     */
    List getBusinessidAndType(ApprovalDTO dto);
    
	void exportApprovals(List<Approval> data, File file);
	
	public void importApproval(Approval approval, Map<String, String> pathMap) throws Exception;
	
	Map<String, Object> importApproval(File excel) throws Exception;
	
	List<Approval> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);
	
	void saveOrUpdateForDS(Approval approval);
    /***
     * 审批导入
     * @param dto
     */
    public void saveArrovalForImport(Approval dto);

    AjaxResult batchSaveApproval(Long[] personIds);

	Approval findById(Long id);
	/**
     *
     * @Decription:通过进程ID查询
     * @author：zhongjianhui
     * @method  findByProcessInstanceId
     * @date：2018/8/8 16:55
     * @params： * @param id
     * @return java.util.Map
     */
    Approval findByProcessInstanceId(String processInstanceId);

	Map findByApprovalId(Long id);


	List<Approval> findAll();
	
	void saveApproval(ApprovalDTO dto);

	Boolean checkProcess(Long approvalId);

    Approval findByBusinessTypeAndUserId(String businessType, Long userId);

    PageResult searchApprovalList_table(Map<Object, Object> p);
    /***
     * 统计审批超时3天
     * @return
     */
    int countTimeOutDays();
    /**
     * 更新新增修改标志
     * @param approval
     */
    void updateFlag(Approval approval);

    /**
     * 内导外数据
     * @param startDate 开始时间
     * @return
     */
    void autoExportApproval(String startDate);

    /**
     * @Author: wangcy
     * @Description:查询待审批的条数
     * @Date: 2018/03/07 0007 17:21
     */
    void findApprovalNumble(ApprovalDTO dto);


  ApprovalFormDto findFormDataByApprovalId(Long approvalId);

    public void createConfirmAndRegisterForm(Approval approval);

    List<Approval> searchUpdateflagForExport();

    /**
     * 发送短信，外网使用
     * @param approval
     */
    void sendMsg(Approval approval);

    public void saveApprovalLog(Approval approval,String approvalstate);

    public void saveApprovalLogNew(Approval approval,String approvalstate);
    
    /**
    * @Author: wangcy
    * @Description:许可备案审批list
    * @Date: 2018/01/18 0018 14:41
    */
    PageResult searchApprovalAndSBList_table(Map<Object, Object> p);

    Approval findBybusinessidAndType(Long businessid, String businesstype);

    void saveApprovalOutreason(ApprovalDTO dto);

    void manualCreateConfirmAndRegisterForm(Approval approval);

    /**
     *
     * @param businessId
     * @param businesstype 类型
     */
    void deleteByBusinessId(Long businessId, String businesstype);
    /**
     * 启动审批流程
     * @param approval
     * @param policeId
     * @param testState
     */
    void startApproval(Approval approval,Long policeId,String testState);

    /**
     * 自动政审
     * @param approval
     */
    void startCensorStatus(Approval approval);
    /**
     *获取同步到外网的数据列表
     * @param filePaths 文件路径列表
     * @param startDate 开始日期
     */
    List<Approval> findDSOutList(List<String> filePaths,String startDate);

    void update(Approval approval);

    void legalChangeSync(Legalchange legalchange);

    /**
     * 查询未启动流程审批记录
     * @return
     */
    List<Approval> findUnStartProcess();
    /***
     * 查询超时未审批记录
     * @param dto 查询条件参数
     * @param ajaxPageResponse 返回数据对象
     * @return 查询列表
     */
    void searchForOutTimeApproval(ApprovalOutTimePageSearchDto dto, AjaxPageResponse<Approval> ajaxPageResponse);

    void searchForPage(ApprovalPageSearchDto dto, AjaxPageResponse<Approval> page);
    ComContract findByIdComContract(Long comContractId);

    PageResult searchApprovalForPage(Map<Object, Object> p);

    /**
     * 登记备案号
     * @param approval
     * @return
     */
    AjaxResult editRecordNo(Approval approval);
}
