package com.bcxin.ars.service.subsidy;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.subsidy.TrainSubsidyConfig;
import com.bcxin.ars.dto.page.TrainSubsidyConfigPageSearchDto;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 培训单位补贴简称批次配置Service接口
 *
 * @author linqinglin
 * @Date 2020-05-27 10:30:45
 */
public interface TrainSubsidyConfigService {

   /****
     * 删除
     * @param trainSubsidyConfig
     * @return
     */
    int delete(TrainSubsidyConfig trainSubsidyConfig);

    /****
     * 保存
     * @param trainSubsidyConfig
     * @return
     */
    void save(TrainSubsidyConfig trainSubsidyConfig);

    /****
     * 选择性修改
     * @param trainSubsidyConfig
     * @return
     */
    void updateSelective(TrainSubsidyConfig trainSubsidyConfig);

    /****
     * 主键查询
     * @param id
     * @return
     */
    TrainSubsidyConfig findById(Long id);

    /**
     * 分页查询
     * @param searchDto
     * @param page
     * @return
     */
    void searchForPage(TrainSubsidyConfigPageSearchDto searchDto, AjaxPageResponse<TrainSubsidyConfig> page);

    /**
     * 批量保存
     * @param list
     */
    void importBatch(List<TrainSubsidyConfig> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<TrainSubsidyConfig> findByBatchId(List<TrainSubsidyConfig> list);
}
