package com.bcxin.ars.service.sb;


import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.ReportData;
import com.bcxin.ars.dto.report.ReportDataSearchDto;
import com.bcxin.ars.dto.sb.TraincompanyapplySearchDto;
import com.bcxin.ars.model.PageResult;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Traincompanyapply;
import com.bcxin.ars.model.sys.Approval;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

import java.util.List;
import java.util.Map;

public interface TraincompanyapplyService {

	/**
	 * 根据主键获取培训信息
	 * @param id
	 * @return
	 */
	Traincompanyapply findById(long id);
	/**
	 *
	 * @Decription:批量查询
	 * @author：zhongjianhui
	 * @method  findByBatchId
	 * @date：2018/8/17 9:15
	 * @params： * @param approvalList
	 * @return java.util.List<com.bcxin.ars.model.sb.Traincompanyapply>
	 */
	List<Traincompanyapply> findByBatchId(List<Approval> approvalList);
	/**
	 *
	 * @Decription:通过id查询处理签打印内容
	 * @author：zhongjianhui
	 * @method  searchForPrintf
	 * @date：2018/10/12 17:08
	 * @params： * @param id
	 * @return java.util.Map
	 */
	Map searchForPrintf(long id);
	/**
	 *
	 * @Decription:批量更新
	 * @author：zhongjianhui
	 * @method  updateBatch
	 * @date：2018/8/17 9:24
	 * @params： * @param list
	 * @return void
	 */
	void updateBatch(List<Traincompanyapply> list);

	void saveOrUpdate(Traincompanyapply traincompanyapply);

	/***
	 * 培训单位申报用于一体化
	 * @param traincompanyapply 培训单位申报信息
	 * @param user 用户信息
	 */
	void saveOrUpdateForIntegrate(Traincompanyapply traincompanyapply, User user);
	void saveOrUpdateForDS(Traincompanyapply traincompanyapply);
	public void updatePoliceId(Traincompanyapply traincompanyapply);
	/***
	 * 查询培训单位信息
	 * @param dto
	 * @return
	 */
	TraincompanyapplySearchDto search(TraincompanyapplySearchDto dto);

	Traincompanyapply findByUser(Long userid);

    List<Traincompanyapply> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

	List<Traincompanyapply> findAll();

	void temporarySave(Traincompanyapply traincompanyapply);

	List<ReportData> findByAreaReport(ReportDataSearchDto searchDto);

	PageResult searchTraincompanyapplyList_table(Map<Object, Object> p);;

    void saveOrUpdateForApproval(Traincompanyapply traincompanyapply);

    void updateCensorStatus(Traincompanyapply traincompanyapply);

    void saveOrUpdateForApprovalImport(Traincompanyapply traincompanyapply);

	/**
	 * 上传承诺书
	 * @param traincompanyapply
	 */
	void savePermitDoc(Traincompanyapply traincompanyapply);

    void searchForPage(TraincompanyapplySearchDto dto, AjaxPageResponse<Traincompanyapply> page);
}
