package com.bcxin.ars.service.sb;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.page.SecAssociationRatingPageSearchDto;
import com.bcxin.ars.model.sb.SecAssociationRating;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

import java.util.List;


/**
 * 保安协会等级评定Service接口
 * 
 * @author lin
 * @date 2021-04-20
 */
public interface SecAssociationRatingService{
    /****
     * 删除
     * @param secAssociationRating
     * @return
     */
    int delete(SecAssociationRating secAssociationRating);

    /****
     * 保存
     * @param secAssociationRating
     * @return
     */
    int save(SecAssociationRating secAssociationRating);

    /****
     * 选择性修改
     * @param secAssociationRating
     * @return
     */
    void updateSelective(SecAssociationRating secAssociationRating);

    /****
     * 主键查询
     * @param id
     * @return
     */
    SecAssociationRating findById(Long id);

    /**
     * 分页查询
     * @param searchDto
     * @param page
     * @return
     */
    void searchForPage(SecAssociationRatingPageSearchDto searchDto, AjaxPageResponse<SecAssociationRating> page);

    /**
     * 外导内查询
     * @param searchDto
     * @return
     */
    List<SecAssociationRating> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    /**
     * 内导外查询
     * @param startDate
     * @return
     */
    List<SecAssociationRating> findDSOutList(String startDate);

    /**
     * 批量保存
     * @param list
     */
    void importBatch(List<SecAssociationRating> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<SecAssociationRating> findByBatchId(List<SecAssociationRating> list);


    /**
     * 受理
     * @param secAssociationRating
     */
    void approve(SecAssociationRating secAssociationRating);
}
