package com.bcxin.ars.service.sb;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.page.GradeSubsidyBatchPageSearchDto;
import com.bcxin.ars.model.sb.GradeSubsidyBatch;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

import java.util.List;

/**
 * 等级证补贴批次Service接口
 *
 * @author linqinglin
 * @Date 2020-05-18 19:43:23
 */
public interface GradeSubsidyBatchService {

    /****
     * 删除
     * @param gradeSubsidyBatch
     * @return
     */
    int delete(GradeSubsidyBatch gradeSubsidyBatch);

    /****
     * 保存
     * @param gradeSubsidyBatch
     * @return
     */
    void save(GradeSubsidyBatch gradeSubsidyBatch);

    /****
     * 选择性修改
     * @param gradeSubsidyBatch
     * @return
     */
    void updateSelective(GradeSubsidyBatch gradeSubsidyBatch);

    void updateGrantState(String id);

    /****
     * 主键查询
     * @param id
     * @return
     */
    GradeSubsidyBatch findById(Long id);

    /**
     * 分页查询
     *
     * @param searchDto
     * @param page
     * @return
     */
    void searchForPage(GradeSubsidyBatchPageSearchDto searchDto, AjaxPageResponse<GradeSubsidyBatch> page);

    /**
     * 外导内查询
     *
     * @param searchDto
     * @return
     */
    List<GradeSubsidyBatch> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    /**
     * 内导外查询
     *
     * @param startDate
     * @return
     */
    List<GradeSubsidyBatch> findDSOutList(String startDate);

    /**
     * 批量保存
     *
     * @param list
     */
    void importBatch(List<GradeSubsidyBatch> list);

    /**
     * 批量查询
     *
     * @param list
     * @return
     */
    List<GradeSubsidyBatch> findByBatchId(List<GradeSubsidyBatch> list);

    void searchForPageInterface(GradeSubsidyBatchPageSearchDto searchDto, AjaxPageResponse<GradeSubsidyBatch> page);

    /**
     * 打回
     *
     * @param gradeSubsidyBatch
     */
    void repulse(GradeSubsidyBatch gradeSubsidyBatch);

    void uploadCommitFile(GradeSubsidyBatch gradeSubsidyBatch);

    /**
     * 补贴申请状态查询
     *
     * @param batchNameSubject 批次名称
     * @return 初审通过/审批不通过/初审中/线下审批中/审批通过
     */
    AjaxResult subsidyApplicationStatusInquiry(String batchNameSubject);


    /**
     * 新增补贴申请
     *
     * @param gradeSubsidyBatchInfo 补贴申请信息
     * @return 成功/失败
     */
    AjaxResult newSubsidyApplication(String gradeSubsidyBatchInfo);
}
