package com.bcxin.ars.service.sb;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.FamilySearchDto;
import com.bcxin.ars.model.sb.Family;

import java.util.List;

public interface FamilyService {

	Family findById(long id);
	
	void saveOrUpdate(Family family);

	void saveOrUpdateForDS(Family family);
	
	FamilySearchDto search(FamilySearchDto dto);

	void delete(Family family);

    List<Family> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

	/**
	 * 通过保安员申报id删除家庭成员
	 * @param personcertificateId
	 */
	void deleteByPersoncertificateId(Long personcertificateId);

	List<Family> searchByPid(Long pid);
}
