package com.bcxin.ars.service.sb;

import com.bcxin.ars.dto.ModelNameDTO;
import com.bcxin.ars.dto.PropertiesDTO;
import com.bcxin.ars.dto.sys.ExportRosterDto;
import com.bcxin.ars.model.User;
import java.util.List;
import java.util.Map;

public interface ExportService {
	/**
	 *
	 * @Decription:
	 * @author：zhongjianhui
	 * @method  exportForExcel
	 * @date：2019/2/28 15:39
	 * @params： * @param propertiesDTO
	 * @param josnStr
	 * @param searchParams
	 * @param user
	 * @param tableExcelName
	 * @return java.lang.String
	 */
	String exportForExcel(PropertiesDTO propertiesDTO, String josnStr, Map<Object, Object> searchParams, User user,String tableExcelName);

    String commonExport(PropertiesDTO propertiesDTO, String josnStr, Map<Object, Object> searchParams, User user, String tableExcelName);

    /**
	 *
	 * @Decription:获取要导出的字段
	 * @author：zhongjianhui
	 * @method  getremeberColumn
	 * @date：2018/11/6 13:22
	 * @params： * @param modelNameDTOList
	 * @param propertiesDTO
	 * @return java.util.List<com.bcxin.ars.dto.ModelNameDTO>
	 */
	List<ModelNameDTO>  chooseExportColumn(PropertiesDTO propertiesDTO, List<ModelNameDTO> modelNameDTOList);


	/***
	 * 通用导出
	 * @param propertiesDTO
	 * @param josnStr
	 * @param searchParams 搜索参数
	 * @param user 用户
	 * @param tableExcelName 表名
	 * @return
	 */
	String commonExportExcel(PropertiesDTO propertiesDTO, String josnStr, Map<Object, Object> searchParams, User user,String tableExcelName);

	/**
	 * 生成excel花名册并返回下载地址
	 * @param exportRosterDto
	 * @return
	 */
	String exportRoster(ExportRosterDto exportRosterDto);

	String autoExportPersonInfo(PropertiesDTO propertiesDTO, String josnStr, Map<Object, Object> searchParams, String tableExcelName);
}
