package com.bcxin.ars.service.sb;

import com.alibaba.fastjson.JSONArray;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.SecurityPersonSearchRerurnDTO;
import com.bcxin.ars.model.sb.Personcertificate;

import java.util.List;

/****
 * 打回接口，各个环境打回条件不一定，各自实现
 */
public interface CustomPersoncertificateService {
    /**
     * @return java.util.List<java.util.Map>
     * @Decription:返回不可流程打回 人的姓名和身份证号
     * @author：zhongjianhui
     * @method checkReturn
     * @date：2018/12/6 15:32
     * @params： * @param perIds
     */
    AjaxResult checkReturn(Long[] perIds);

    /**
     * @return java.util.List<Personcertificate>
     * @Decription:返回不可流程打回 人的姓名和身份证号,id
     * @author：zhongjianhui
     * @method getUnCanReturn
     * @date：2018/12/6 15:32
     * @params： * @param perIds
     */
    List<Personcertificate> getNoReturnList(Long[] perIds);


    /**
     *
     * @Decription:根据公司id查找人员
     * @author：zhongjianhui
     * @method  findPersonByCompanyId
     * @date：2018/6/19 9:45
     * @params： * @param companyId
     * @return java.util.List<com.bcxin.ars.dto.SecurityPersonDTO>
     */
    SecurityPersonSearchRerurnDTO findPersonByCompanyIdSearchReturnDTO(SecurityPersonSearchRerurnDTO securityPersonSearchRerurnDTO);

    /**
     * @Decription:获取保安员证消息模板
     * @param tempType 模板类型 1内容 0标题
     * @param testState 考试状态
     * @return
     */
    String getMsgTemp(String tempType,String testState);
    /**
     * @Decription:获取保安员证消息模板
     * @param tempType 模板类型 1内容 0标题
     * @param testState 考试状态
     * @return
     */
    String getMsgTemp_V1171(String tempType, String testState);
    /**
     * @Decription:获取保安员证消息模板
     * @param tempType 模板类型 1内容 0标题
     * @param testState 考试状态
     * @return
     */
    String getMsgTemp_V1172(String tempType, String testState);

    /**
     * 保安员证外网同步到内网
     * @param personcertificate
     */
    void updateForDSByDiffArea(Personcertificate personcertificate);

    JSONArray checkReturnList(List<Personcertificate> list);
}
