package com.bcxin.ars.service.sb;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.page.ApproveAttachmentPageSearchDto;
import com.bcxin.ars.model.sb.ApproveAttachment;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

import java.util.List;


/**
 * 审批补充材料Service接口
 * 
 * @author lin
 * @date 2021-05-06
 */
public interface ApproveAttachmentService{
    /****
     * 删除
     * @param approveAttachment
     * @return
     */
    int delete(ApproveAttachment approveAttachment);

    /****
     * 保存
     * @param approveAttachment
     * @return
     */
    int save(ApproveAttachment approveAttachment);

    /****
     * 选择性修改
     * @param approveAttachment
     * @return
     */
    void updateSelective(ApproveAttachment approveAttachment);

    /****
     * 主键查询
     * @param id
     * @return
     */
    ApproveAttachment findById(Long id);

    /**
     * 分页查询
     * @param searchDto
     * @param page
     * @return
     */
    void searchForPage(ApproveAttachmentPageSearchDto searchDto, AjaxPageResponse<ApproveAttachment> page);

    /**
     * 外导内查询
     * @param searchDto
     * @return
     */
    List<ApproveAttachment> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    /**
     * 内导外查询
     * @param startDate
     * @return
     */
    List<ApproveAttachment> findDSOutList(String startDate);

    /**
     * 批量保存
     * @param list
     */
    void importBatch(List<ApproveAttachment> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<ApproveAttachment> findByBatchId(List<ApproveAttachment> list);


}
