package com.bcxin.ars.service.msg;

import java.util.List;
import java.util.Map;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.msg.SysAttachment;

public interface SysAttachmentService {

	void saveOrUpdate(SysAttachment sysAttachment);

	void delete(SysAttachment sysAttachment);
	
	SysAttachment findById(Long id);

	void delete(Long id);
	
	List<SysAttachment> findAllByBusiness(String businessid, String businesstype);

    /**
     *获取同步到外网的数据列表
     * @param filePaths 附件地址列表
     * @param startDate 开始日期
     */
    List<SysAttachment> findDSOutList(List<String> filePaths,String startDate);

    void saveOrUpdateForImport(SysAttachment sysAttachment);

    void saveOrUpdateForImport2(SysAttachment sysAttachment, Map<String, String> pathMap);

    List<SysAttachment> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    void saveOrUpdateForDS(SysAttachment sysAttachment);

    SysAttachment findByBusiness(SysAttachment sysAttachment);

    /**
     * @Decription:批量保存修改
     * @param list
     * @return
     */
    void importBatch(List<SysAttachment> list,Map<String, String> pathMap);
}
