package com.bcxin.ars.service.msg;


import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.msg.NewsnoticeCompanySearchDto;
import com.bcxin.ars.model.PageResult;
import com.bcxin.ars.model.msg.NewsnoticeCompany;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

import java.util.List;
import java.util.Map;

/**
 * 公司消息通知
 * @author Ethan
 */
public interface NewsnoticeCompanyService {

	/**
	 * 查询公司消息通知
	 * @param dto
	 * @return
	 */
	public NewsnoticeCompanySearchDto search(NewsnoticeCompanySearchDto dto);

	PageResult searchNewsnoticeCompanyList_table(Map<Object, Object> p);


    /***
     * 查询消息回复附件用于公安端
     * @param p
     * @return
     */
    PageResult searchNewsnoticeCompanyReplyListForPolice(Map<Object, Object> p);
    /***
     * 查询消息回复附件用于公安端
     * @param p
     * @return
     */
    PageResult searchNewsnoticeCompanyReplyListForCompany(Map<Object, Object> p);

	/**
	 * 批量更新已读未读状态(企业端)
	 * @param idArray
	 */
	void updateReadstateByidArr(Long[] idArray);


    /**
     * 批量更新已读未读状态(公安端)
     * @param idArray
     */
    void updateReadstateByIdForPolice(Long[] idArray);

	List<NewsnoticeCompany> findUnread();

	int countUnread();

	void updateReaded(NewsnoticeCompanySearchDto newsnoticeCompany);

    NewsnoticeCompany findById(Long id);

    /**
    * @Author: wangcy
    * @Description:同步数据
    * @Date: 2018/03/08 0008 15:00
    */
	List<NewsnoticeCompany> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

	/**
	 * @Author: wangcy
	 * @Description:内网同步数据
	 * @Date: 2018/03/08 0008 15:00
	 */
    void saveOrUpdateForDS(NewsnoticeCompany newsnoticeCompany);

	/**
	 *获取同步到外网的数据列表
	 * @param startDate 开始日期
	 */
	List<NewsnoticeCompany> findDSOutList(String startDate);

	void saveOrUpdateForImport(NewsnoticeCompany newsnoticeCompany);

    /**
     * 保存消息回复
     * @param  newsnoticeCompany
     */
    void saveOrUpdate(NewsnoticeCompany newsnoticeCompany);

    void searchForPage(NewsnoticeCompanySearchDto dto, AjaxPageResponse<NewsnoticeCompany> page);
}
