package com.bcxin.ars.service.gen;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.gen.GenTable;
import com.bcxin.ars.dto.page.GenTablePageSearchDto;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 代码生成业务表Service接口
 *
 * @author linqinglin
 * @Date 2020-08-09 08:11:23
 */
public interface GenTableService {

    /****
     * 删除
     * @param genTable
     * @return
     */
    int delete(GenTable genTable);

    /****
     * 保存
     * @param genTable
     * @return
     */
    int save(GenTable genTable);

    /****
     * 选择性修改
     * @param genTable
     * @return
     */
    void updateSelective(GenTable genTable);

    /****
     * 主键查询
     * @param id
     * @return
     */
    GenTable findById(Long id);

    /**
     * 分页查询
     * @param searchDto
     * @param page
     * @return
     */
    void searchForPage(GenTablePageSearchDto searchDto, AjaxPageResponse<GenTable> page);

    /**
     * 批量保存
     * @param list
     */
    void importBatch(List<GenTable> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<GenTable> findByBatchId(List<GenTable> list);

    List<GenTable> selectDbTableListByNames(String[] tableNames);

    void importGenTable(List<GenTable> tableList);

    void selectDbTableList(GenTable genTable, AjaxPageResponse<GenTable> page);

    Map<String, String> previewCode(Long tableId);

    byte[] downloadCode(String tableName);

    byte[] downloadCode(String[] tableNames);
}
