package com.bcxin.ars.service.exam;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.exam.TrainExamPersonSearchDto;
import com.bcxin.ars.model.PageResult;
import com.bcxin.ars.model.exam.TrainExamPerson;

/**
 * 考试人员信息管理
 *
 * @author wangjianchi
 * @since 1.1
 */
public interface TrainExamPersonService {

	PageResult query(TrainExamPersonSearchDto dto);

    /**
     * 查看考试人员所有考试信息
     *
     * @param dto
     * @return
     */
    PageResult queryHistory(TrainExamPersonSearchDto dto);

	List<TrainExamPerson> list(TrainExamPersonSearchDto dto);

	TrainExamPerson findById(Long id);

	/**
	 * 删除考试人员信息
	 * 
	 * @param id
	 */
	void deleteById(Long id);

	TrainExamPerson updateScore(TrainExamPerson trainExamPerson);
	/**
	 *
	 * @Decription:流程打回通过审批id删除已安排考试的人
	 * @author：zhongjianhui
	 * @method  deleteTest
	 * @date：2018/12/27 10:58
	 * @params： * @param idNumber
	 * @return void
	 */
	void deleteTestForApporvalId(Long[] id);
	/**
	 * 批量新增考试学员到指定考场功能
	 *
	 * @param trainExamPersons
	 * @return
	 */
	String batchSave(List<TrainExamPerson> trainExamPersons);

	/**
	 * 导出考场学员数据
	 *
	 * @param examID
	 */
	AjaxResult exportData(Long examID);

	/**
	 * 下载考场学员信息Excel
	 *
	 * @param resultBeansJSON
	 * @param os
	 */
	void downLoad(String resultBeansJSON, OutputStream os);

	/**
	 * 下载录入学员名单Excel模板
	 * 
	 * @param examID
	 * @param os
	 * @return
	 */
	AjaxResult template(Long examID, OutputStream os);

	/**
	 * 录入学员名单成绩
	 * 
	 * @param examID
	 * @param inputStream
	 * @param fileType
	 * @return
	 */
	AjaxResult importResult(Long examID, InputStream inputStream, String fileType) throws IOException;

	/**
	 * 发送考试通知
	 * 
	 * @param trainExamPersonSearchDto
	 */
	String sendExamNotice(TrainExamPersonSearchDto trainExamPersonSearchDto);

	/**
	 * 发送成绩通知
	 * 
	 * @param trainExamPersonSearchDto
	 */
	String sendScoreNotice(TrainExamPersonSearchDto trainExamPersonSearchDto);

	/**
	 * 导入考试人员信息
	 * @param searchDto
	 * @return
	 */
    List<TrainExamPerson> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

	/**
	 * 数据导入
	 * @param trainExamPerson
	 */
	void saveOrUpdateForDS(TrainExamPerson trainExamPerson);

}
