package com.bcxin.ars.service.exam;

import java.util.List;
import java.util.Map;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.exam.TrainExamInfoDto;
import com.bcxin.ars.dto.exam.TrainExamInfoSearchDto;
import com.bcxin.ars.model.PageResult;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.exam.TrainExamInfo;

/**
 * 考试信息管理
 *
 * @author zhangye
 * @since 1.1
 */
public interface TrainExamInfoService {

	public PageResult query(TrainExamInfoSearchDto trainExamInfoSearchDto);

	public void save(TrainExamInfoDto trainExamInfoDto, User user);

	public TrainExamInfoDto update(TrainExamInfoDto trainExamInfoDto, User user);

	public TrainExamInfo selectByPrimaryKey(Long examID);

	public List<TrainExamInfo> list(TrainExamInfoDto trainExamInfoDto);

	public int cancel(TrainExamInfoDto trainExamInfoDto, User user);

	/**
	 * 导出考试相关表数据(内网)
	 *
	 * @return
	 */
	public Map<String, Object> exportExamData();

	/**
	 * 导入考试相关表数据(外网)
	 *
	 * @return
	 */
	public void importExamData(Map<String, Object> examData);

	/**
	 * 导入考试信息数据
	 *
	 * @param searchDto
	 * @return
	 */
	List<TrainExamInfo> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

	/**
	 * 数据导入
	 *
	 * @param trainExamInfo
	 */
	void saveOrUpdateForDS(TrainExamInfo trainExamInfo);

	/**
	 * 根据地区编码同步百课堂考试信息和考试人员信息
	 *
	 * @param areaCode
	 */
	void saveExamInfoFromTrain(String areaCode);
}
